<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

// no update to lastRequestTime in sess
// sessionRefresh request must not update the applications session time
$App->setSession('lastRequestTime',$lastRequestTime);

// If this function returns a value != "", the browser will call loads
// the page with the CA given in the return string.
$sessionTimeout = $App->getConfig('SESSION_TIMEOUT','480');
if (! $sessionTimeout) {
    $sessionTimeout = 15;
}
$logoffTime = time() - $sessionTimeout * 60;

if ($lastRequestTime <= $logoffTime) {
    $App->log('Session time out for user '.$USER->id,1);
    $App->response('Session timeout','text-plain');
}

exit; //async request ends here
?>
