#!/usr/bin/perl
#
# AUTHPROTOCOL: STDIN2
#
use strict;
use Carp;
use DBI;

my $configfile = '/etc/benno-web/benno.conf';
my $config = read_config($configfile);
my $dbh = db_connect($config);


my $sth = $dbh->prepare("SELECT VALUE FROM appstate WHERE id = 'dbversion' ORDER BY VALUE DESC LIMIT 1");
$sth->execute(); 
my $dbversion = ($sth->fetchrow_array)[0];

if ($dbversion >= '2019121301') {
    exit 0;
}

# create containertable
$sth = $dbh->prepare("CREATE TABLE container (userid varchar(64) NOT NULL default '', cid varchar(128) NOT NULL default '', scid varchar(128) NOT NULL default '', PRIMARY KEY (userid,cid,scid));"); 
$sth->execute(); 

# update dbversion
$sth = $dbh->prepare("INSERT INTO appstate (id,value) VALUES ('dbversion','2019121301')");
$sth->execute(); 

# convert archives
$sth = $dbh->prepare("SELECT id,archive FROM user");
$sth->execute(); 
while (my ($userid,$archive) = $sth->fetchrow_array) {
    my @containers = split /,\s*/, $archive;

    foreach my $cnt (@containers) {
        my ($cid,$scid) = split(/\//,$cnt);
        $scid = '' unless $scid;
        $dbh->do(q{INSERT INTO container (userid,cid,scid) VALUES (?,?,?)},
            undef, $userid,$cid,$scid);
    }
}


### SUBS ######################################################################
# read_config
sub read_config
{
    my $configfile = shift;

    my $config = {};
    open CONF, $configfile or croak "Cannot open config file $configfile. $!\n";
    foreach my $line (<CONF>) {
        next if $line =~ /^$/;
        next if$line  =~ /^#/;
        chomp $line;
        my ($param,$value) = split(/\s*=\s*/,$line,2);
        $config->{$param} = $value;
    }

    return $config;
}


# db_connect
sub db_connect
{   
    my $config = shift;

    my $dbtype = $config->{DBTYPE} || 'sqlite:////var/lib/benno-web/bennoweb.sqlite';
    my $db     = $config->{DATABASE};
    my $dbhost = $config->{DBHOST} || 'localhost';
    my $dbport = $config->{DBPORT} || 3306;
    my $dbuser = $config->{DBUSER};
    my $dbpass = $config->{DBPASS};
    my $DBH;
    if ($dbtype eq 'mysql') {
        eval {
            my $dsn = "DBI:mysql:database=$db;host=$dbhost;port=$dbport";
            $DBH = DBI->connect($dsn,$dbuser,$dbpass);
        };
        if ($@) {
            print STDERR "ERROR: MySQL Driver not installed.\n";
            exit 1;
        }
    }
    else {
        if ($dbtype =~ /^sqlite:\/\/(\/.\S+)$/) {
            my $dsn = "dbi:SQLite:dbname=$1","","";
            $DBH = DBI->connect($dsn);
        }
    }
    return $DBH;
}

