<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

$sendmail_cmd = $App->getConfig('SENDMAIL_CMD','/usr/sbin/sendmail');
$mail_from = $App->getConfig('MAIL_FROM','benno');

$sessionMailId = $App->getParam('sessionMailId');
$mailTo = $App->getParam('mailTo');

try {
    $rawMail = $Backend->fetchRaw($archive,$sessionMailId);
    // Linebreak in $rawMail must be \r\n. Otherwise the whole mail content
    // (whith headers) will be send as mail body.
    $rawMail = preg_replace('/^Message-Id:/im','X-Benno-Resent-Message-Id:',$rawMail);

    $msgIdHeader = 'Message-ID: <'.uniqid('',true).'@'.php_uname('n').'>';

    $send_to = escapeshellarg($mailTo);
    $sendmail = "$sendmail_cmd -i -r $mail_from $send_to 2>&1";
    $ph = popen($sendmail,'w');
    if (!$ph) { throw new Exception("Cannot exec command \"$sendmail\""); }
    $ret = fwrite($ph,$msgIdHeader."\r\n".$rawMail);
    if (!$ret) {
        fclose($ph);
        throw new Exception("Cannot write mail to \"$sendmail\"");
    }
    fclose($ph);

    $bennoId = QueryResult::getBennoId($sessionMailId);
    $Audit->log("MAIL $archive:".$bennoId.' >> '.$mailTo);
}
catch (Exception $e) {
    $App->log('[a_forward] '.$e->getMessage());
}

// no more output needed!
exit;
?>
