<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
$authscript  = $App->getConfig('EXTERNAL_AUTH','/usr/lib/benno-web/benno_dbauth');

// Authentication
if (! $passwd) {
    $message = 'No password given';
    $App->log($message,1);
    auth_exit($message);
}

$USER = new User($userid);
try {
    if ($authscript && is_readable($authscript)) {
        $USER->loadExternal($authscript,$passwd);
    }
    else {
        $App->log("Cannot read \"$authscript\". Fallback authentication.");
        $USER->load();
        // check authentication
        if ($USER->password != md5($passwd)) {
            throw new Exception('ERR_AUTH');
        }
    }
}
catch (Exception $e) {
    // Authentication error -> redirect to login
    $message = $e->getMessage();
    $App->log($message);
    auth_exit($message);
}

// Authentication successful
$App->setSession('USER',$USER);

?>
