<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
$data = $App->getParam('data');

$EditUser = $App->getSession('EditUser');
$App->setSession('EditUser','');

if (!$EditUser) {   // new user
    $BennoUser = new User($data['id']);
}
else {
    $BennoUser = new User($EditUser->id);
    $BennoUser->load();
}

if ($USER->permission('USERINFO')) {
    $BennoUser->name = $data['name'];
}

if ($USER->permission('ADDRESS')) {
    $addresses = array();
    $addrlist = json_decode($data['addresses'],true);
    if ($addrlist) {
        foreach($addrlist as $k => $v) {
            array_push($addresses,$v['value']);
        }
    }
    $BennoUser->addresses = array_unique($addresses);
}

if ($USER->permission('PASSWD')) {
    if ($data['password0']) {
        if ($data['password0'] == $data['password1']) {
            $BennoUser->setPassword($data['password0']);
        }
        else {
            $App->setSession('editUser',$BennoUser);
            $App->redirect('editUser',
                    array('MSG' => 'ERR_NOPWMATCH')
            );
        }
    }
}

if ($USER->permission('ROLE')) {
    $BennoUser->role = $data['role'];
}
else {
    $BennoUser->role = $USER->getRole();
}

foreach ($USER->getArchives(false) as $container) { // no SYSINFO
    $BennoUser->addArchive($container);
}

$BennoUser->save();

$App->redirect('userList',array('MSG' => 'MSG_UPDATED'));
?>
