<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/** $Id: $
 *
 */
/**
 * @package AppState
 */
/**
 *
 * Access status object data from storage
 *
 */
require_once 'SPAF2/Persistence.php';

class AppState extends Persistence
{

    /** id
     *
     * @access public
     * @var string
     */
    var $id;


    /** userid
     *
     * @access public
     * @var string
     */
    var $userid;


    /** value
     *
     * @access public
     * @var string
     */
    var $value;


    /**
     * constructor
     *
     *
     * @access public
     * @param string $userid
     * @return object
     */
    function __construct($userid,$param='',$value='')
    {
        $this->userid = $userid;
        $this->id = $param;
        $this->value = $value;
    }


    // load objects from storage backend
    // overwrite load method in persistence
    /**
     * getValue
     *
     * fetch value from db backend
     *
     * @access public
     * @param string $param
     * @param string $default (if $value is empty, optional)
     * @return string $value
     */
    function getValue($param,$default='')
    {
        global $App;
        $entries = array();
        $DB = $App->DB;
        $sql = "SELECT * FROM appstate WHERE id = '".$param."' AND userid = '".$this->userid."'";
        $res = $DB->query($sql);
        $row = $res->fetchRow();
        if (isset($row['value'])) {
            $value = $row['value'];
        }
        else {
            $value = $default;
        }
        return $value;
    }


    /**
     * saveValue for id
     *
     * store value in db backend
     *
     * @access public
     * @param string $param
     * @param string $value
     */
    function saveValue($param,$value)
    {
        $this->id = $param;
        $this->value = $value;
        parent::save();
    }

}
?>
