<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
/**
 * @package Audit
 */

class Audit
{

    /** enabled
     *
     * @access private
     * @var bool
     */
    var $enabled;


    /** logfile
     *
     * @access private
     * @var string
     */
    var $logfile;


    /** loghandle
     *
     * @access private
     * @var string
    */
    var $loghandle;


    function __construct()
    {
        global $App;
        $this->enabled = false;

        if ($logdir = $App->getConfig('AUDIT_LOGDIR')) {
            if (!is_writable($logdir)) {
                if (mkdir($logdir)) {
                    $this->enabled = true;
                }
            }
            else {
                $this->enabled = true;
            }
        }

        if ($this->enabled) {
            $User = $App->getSession('USER');
            $this->logfile = $logdir.'/'.$User->id.'_'.date('Y-m-d').'.log';
            if (!$this->loghandle = @fopen($this->logfile,'a')) {
                $App->log('Cannot open audit logfile '.$this->logfile);
                $this->enabled = false;
            }
            else {
                flock($this->loghandle, LOCK_UN);
            }
        }
    }


    function log ($string)
    {
        global $App;
        // write if audit logging is enabled
        if ($this->enabled) {
            if (flock($this->loghandle, LOCK_EX)) {
                $now = date('H:i:s');
                fwrite($this->loghandle, $now.' '.$string."\n");
            }
            else {
                $App->log('Cannot obtain lock to '.$this->logfile,0,'Audit');
            }
            flock($this->loghandle, LOCK_UN);
        }
    }
    
}
