<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/**
 *
 * Internal benno ids must not be callable for users.
 * QueryResult stores a table <internalId> -> <bennoId> in session, to
 * allow other components accessing emails from resultlists via internalId.
 *
 */

require_once 'model/EMail.php';

class QueryResult
{

    var $mailList;
    var $first;        // # of first mail
    var $last;         // # of last mail
    var $found;
    var $limit;
    var $count;
    var $overall;
    var $licenseStatus;
    var $Query;        // Query object


    function __construct($resultList,$Query,$limit)
    {
        global $App;

        if (!is_array($resultList)) {
            $resultList = [];
            $resultList['first'] = -1;
            $resultList['last']  = -1;
            $resultList['limit'] = -1;
            $resultList['count'] = -1;
            $resultList['found'] = '0';
            $resultList['overall'] = 0;
            $resultList['results'] = 0;
            $resultList['licenseValid'] = 1;
        }

        $this->first = $resultList['first'];
        $this->last = $resultList['last'];

        $this->limit = $resultList['limit'];
        $this->count = $resultList['count'];
        $this->found = $resultList['found'];
        $this->overall = @$resultList['overall'];
        $this->licenseStatus = $resultList['licenseValid'];

        // bennoIdTable is session-local
        $bennoIdTable = $App->getSession('bennoIdTable');
        $mailList = array();
        for($i=0;$i<=$resultList['count']-1;$i++) {
            // $i $from $to $multipart $subject $summary $date 
            // MailId is last in tupel
            $akt = $resultList['results'][$i];

            if (!($sessionMailId = @$bennoIdTable[$akt['id']])) {
                $sessionMailId = $i.'_'.uniqid();   // prevent two windows accessing the same email
                $bennoIdTable[$akt['id']] = $sessionMailId;
            }
            $EMail = new EMail($sessionMailId,$Query->archive,$akt['id'],$akt['From'],$akt['To'],$akt['Cc'],$akt['Bcc'],$akt['Subject'],$akt['Date'],'','',$akt['hasAttachment']);

            array_push($mailList,$EMail);
        }
        $App->setSession('bennoIdTable',$bennoIdTable);
        $this->mailList = $mailList;
        $this->Query = $Query;
    }


    /**
     * Returns sessionMailId for sequence number of current resultlist
     *
     * @access public
     * @param int $resultnum
     * @return string $bennoId
     */
    function getSessionMailId($resultnum)
    {
        global $App;
        if (!isset($this->mailList[$resultnum])) {
            $App->log("Email object with result id $resultnum not defined",1);
            throw new Exception("ID_NOT_FOUND");
        }
        return $this->mailList[$resultnum]->id;
    }


    /**
     * Returns array of EMail objects
     *
     * @access public
     * @return array EMail
     */
    function fetchMails()
    {
        return $this->mailList;
    }

    function numAll () {
        global $App;

        if ($this->overall > 0) {
            $App->lang == 'en' ? $tsnd_sep = ',' : $tsnd_sep = '.';
            return number_format($this->overall,0,'',$tsnd_sep);
        }
        return '';
    }

    function numFirst () { return $this->first; }

    function numLast  () { return $this->last; }

    function jumpPrev () { return $this->first-$this->limit; }

    function jumpNext ()
    {
        if (($this->last) >= ($this->found-1)) {  // jump behind end
            return $this->jumpEnd();
        }
        return $this->last+1;
    }

    function jumpEnd  ()
    {
        if ($this->found == $this->limit) {         // # found == limit
            return 0;
        }
        $modulo = $this->found % $this->limit;      // jump to last page
        return $this->found-$modulo+1;              // in limit raster
    }


    /*
     * CLASS METHODS
     */

    /**
     * Class method that returns bennoId from session-global sessionMailId
     * table.
     *
     * @access public
     * @param string $sessionMailId
     * @return string $bennoId
     */
    public static function getBennoId($sessionMailId)
    {
        global $App;
        $bennoIdTable = $App->getSession('bennoIdTable');
        $bennoId = array_search($sessionMailId,$bennoIdTable);
        if ($bennoId == false) {
            $App->log("Email object with sessionMailId $sessionMailId not defined",1);
            throw new Exception("ID_NOT_FOUND");
        }
        return $bennoId;
    }

}
?>
