<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/** $Id: $
 *
 */
/**
 * @package User
 */
/**
 *
 * User
 *
 */
require_once 'model/UserDA.php';

class User extends UserDA
{
    /** id
     *
     * @access private
     * @var string
     */
    var $id;


    /** password
     *
     * @access private
     * @var string
     */
    var $password;


    /** display name of user
     *
     * @access private
     * @var string
     */
    var $name;


    /** archive to access
     *
     * @access private
     * @var array
     */
    var $archive = array();


    /** addresses
     *
     * @access private
     * @var array
     */
    var $addresses;


    /** role
     *
     * @access public
     * @var string
     */
    var $role;


    /** permission
     *
     * @access public
     * @var archive
     */
    var $permission = [];



   /**
     * restdata
     *
     * Information about REST backend
     *  rest['URL']
     *  rest['USER']
     *  rest['PASS']
     *
     * @access public
     * @var array
     */
    var $restdata;


   /**
     * authparam
     *
     * Authentication parameters
     *
     * @access public
     * @var array
     */
    var $authparam;


   /**
     * filter
     *
     * Additional filters
     *
     * @access public
     * @var array
     */
    var $filter;


    /**
     * constructor
     *
     *
     * @access public
     * @param string $userid
     * @param string $password optional
     * @param string $archive optional
     * @param string $role optional
     * @param array $addresses optional
     * @param array $restdata optional
     * @param array $authparam optional
     * @param array $filter optional
     * @return object
     */
    function __construct($id,$password='',$name='',$archive=array(),$role='',$adresses=array(),$restdata=array(),$authparam=array(),$filter=array())
    {
        $this->id = $id;
        $this->password = $password;
        $this->name = $name;
        $this->archive = $archive;
        $this->role = $role;
        $this->addresses = $adresses;
        $this->restdata = $restdata;
        $this->authparam = $authparam;
        $this->filter= $filter;

        $this->permission['SYSINFO']   = false;   // show sysinfo
        $this->permission['SYSDATA']   = false;   // show SYSDATA container
        $this->permission['STATS']     = false;   // show server statistics
        $this->permission['PASSWD']    = false;   // change password
        $this->permission['USERINFO']  = false;   // change userdata (name, ...)
        $this->permission['ADDRESS']   = false;   // change adresses
        $this->permission['ROLE']      = false;   // change role
        $this->permission['CONTAINER'] = false;   // change container

    }

    function getAuthzLevel () {
        $level = 0b0;

        // defined in pre_init

        // BNO_AUTH       2 User authenticated
        // BNO_USER       4 userpanel (change password)
        // BNO_USERADMIN  8 user admin (change password, userinfo)
        // BNO_SYSINFO   16 see sysinfo / SYSDATA container
        // BNO_ADMIN     32 admin (change address,role)
        // BNO_SITEADM   64 siteadmin (change container, siteadmin role)

        if ($this->role == 'AUTH')      { $level = BNO_AUTH;}
        if ($this->role == 'USER')      { $level = BNO_AUTH|BNO_USER;}
        if ($this->role == 'USERADMIN') { $level = BNO_AUTH|BNO_USER;}
        if ($this->role == 'REVISOR')   { $level = BNO_AUTH|BNO_SYSINFO;}
        if ($this->role == 'ADMIN')     { $level = BNO_AUTH|BNO_USER|BNO_SYSINFO|BNO_ADMIN;}
        if ($this->role == 'SITEADMIN') { $level = BNO_AUTH|BNO_USER|BNO_SYSINFO|BNO_ADMIN|BNO_SITEADMIN;}

        return $level;
    }


    function setPassword ($pass) { $this->password = password_hash($pass,PASSWORD_BCRYPT); }

    function getName () { return $this->name; }
    function setName ($name) { $this->name = $name; }

    function getArchives ($sysinfo=true) {
        $clist = array();
        if ($sysinfo && $this->permission('SYSDATA')) {
            array_push($clist,'SYSDATA');
        }
        $clist = array_merge($clist,$this->archive);

        return $clist;
    }

    function hasArchive($archive) {
        $retval = false;
        if (in_array($archive,$this->getArchives())) {
            return true;
        }
        return false;
    }

    function addArchive ($archive) {
        array_push($this->archive,$archive);
        $this->archive = array_unique($this->archive);
        sort($this->archive);
    }

    function getAuthParam ($param) { return $this->authparam[$param]; }

    function getAdresses () { return $this->adresses; }
    function setAdresses ($adresses) { $this->adresses = $adresses; }

    function setRestData ($restdata) { $this->restdata = $restdata; }
    function getRestData () { return $this->restdata; }

    function getRole () { return $this->role; }
    function setRole ($role) { $this->role = $role; }

    function getFilter() { return $this->filter; }

    function permission($permission)      { return $this->permission[$permission]; }
    function setPermission($permission)   { $this->permission[$permission] = true; }
    function unsetPermission($permission) { $this->permission[$permission] = false; }

}
?>
