<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
require_once 'model/return_exit.php';
require_once 'SPAF2/Application.php';
require_once 'model/User.php';
require_once 'model/Filter.php';
require_once 'init_session.php';

$configfile = "/etc/benno-web/benno.conf";
$UNICODE=TRUE;

ob_start();
$App = new Application($configfile,$_REQUEST,'');

if (isset($_SERVER['PHP_AUTH_USER'])) {
    $userid = $_SERVER['PHP_AUTH_USER'];
    $passwd = $_SERVER['PHP_AUTH_PW'];
    require 'ctrl/rest_auth.php';
}
if (preg_match('/^\/login\/?$/',$_SERVER['PATH_INFO'])) {
    if (!isset($userid)) {
        $userid = $App->getParam('username');
        $passwd = $App->getParam('password');
    }
    require 'ctrl/rest_auth.php';
    require 'view/rest_auth.php';       // exit in view/rest_auth.php
}

$USER = $App->getSession('USER');
if (!$USER) {
    $message = 'Request not authenticated.';
    auth_exit($message);
}

require 'view/rest_backend.php';

?>
