#!/bin/sh
# postinst script for benno-archive
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    configure)
    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac


chown benno.benno /var/log/benno
chown benno.benno /srv/benno/archive
chown benno.benno /srv/benno/inbox
chmod 2770 /srv/benno/inbox

if [ -x "/etc/init.d/benno-archive" ]; then
	update-rc.d benno-archive defaults >/dev/null
	#if [ -x "`which invoke-rc.d 2>/dev/null`" ]; then
	#	invoke-rc.d benno-archive start
	#else
    set +e
    /etc/init.d/benno-archive start
	#fi
fi

exit 0
