/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoarchive;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.BennoShutdownInterceptor;
import de.lwsystems.mailarchive.IBennoApplication;
import de.lwsystems.mailarchive.bennoarchive.ManagementClient;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.mailservice.IMailService;
import de.lwsystems.mailarchive.mailservice.IMailServiceHost;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

public final class BennoArchive
implements IMailServiceHost,
IBennoApplication {
    private static final Logger LOGGER = Logger.getLogger(BennoArchive.class);
    private transient Benno benno;
    private transient String managementAddress = "127.0.0.1";
    private transient int managementPort = 0;
    private final ArrayList<IMailService> services = new ArrayList();
    private ServerSocket managementSocket = null;

    public static void main(String[] args) throws Exception {
        boolean success = false;
        try {
            Benno.configureLogging();
            BennoArchive archive = new BennoArchive();
            if (archive.getBenno(args, false)) {
                archive.start();
            }
        }
        catch (Throwable ex) {
            System.err.println(ex.toString());
            LOGGER.fatal((Object)ex.toString());
        }
    }

    BennoArchive() {
    }

    private boolean getBenno(String[] args, boolean readOnly) throws Exception {
        boolean success = false;
        String cmdlineAddress = "0";
        BennoConfig config = null;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        OptionBuilder.withArgName((String)"ADDRESS");
        OptionBuilder.withLongOpt((String)"bind-address");
        OptionBuilder.withDescription((String)"bind managemet to address ADDRESS");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.withArgName((String)"PORT");
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.withDescription((String)"start management interface on port PORT");
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withArgName((String)"CONFIGFILE");
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"use configuraton from CONFIGFILE");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"print this description");
        options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"print-config");
        OptionBuilder.withDescription((String)"print out actual configuration");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"default-config");
        OptionBuilder.withDescription((String)"print out default configuration");
        options.addOption(OptionBuilder.create());
        try {
            CommandLine cmdl = parser.parse(options, args, true);
            if (cmdl.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("java -jar bennoarchive.jar", options);
                Runtime.getRuntime().exit(0);
            } else {
                File configfile = null;
                if (cmdl.hasOption("c")) {
                    configfile = new File((String)cmdl.getParsedOptionValue("c"));
                    if (!configfile.exists()) {
                        throw new IllegalArgumentException("configfile \"" + cmdl.getParsedOptionValue("c") + "\" does not exist!");
                    }
                    if (!configfile.isFile()) {
                        throw new IllegalArgumentException("configfile \"" + cmdl.getParsedOptionValue("c") + "\" is not a file!");
                    }
                    if (!configfile.canRead()) {
                        throw new IllegalArgumentException("configfile \"" + cmdl.getParsedOptionValue("c") + "\" cannot be read!");
                    }
                }
                if (configfile == null) {
                    configfile = new File("benno.xml");
                    if (configfile != null && !configfile.exists()) {
                        configfile = null;
                    }
                    if (configfile != null && !configfile.isFile()) {
                        configfile = null;
                    }
                    if (configfile != null && !configfile.canRead()) {
                        configfile = null;
                    }
                    if (configfile == null) {
                        configfile = new File("/etc/benno/benno.xml");
                        if (configfile != null && !configfile.exists()) {
                            configfile = null;
                        }
                        if (configfile != null && !configfile.isFile()) {
                            configfile = null;
                        }
                        if (configfile != null && !configfile.canRead()) {
                            configfile = null;
                        }
                    }
                }
                if (configfile == null) {
                    System.err.println("No configfile found, exiting");
                    LOGGER.fatal((Object)"No configfile found, exiting");
                    Runtime.getRuntime().exit(99);
                }
                config = (BennoConfig)Benno.getPersister().read(BennoConfig.class, configfile);
                if (cmdl.hasOption("b")) {
                    cmdlineAddress = (String)cmdl.getParsedOptionValue("b");
                }
                if (cmdl.hasOption("p")) {
                    this.managementPort = ((Number)cmdl.getParsedOptionValue("p")).intValue();
                }
                if (cmdl.hasOption("print-config")) {
                    Benno.getPersister().write((Object)config, (OutputStream)System.out);
                    Runtime.getRuntime().exit(0);
                }
            }
        }
        catch (Exception exp) {
            HelpFormatter formatter = new HelpFormatter();
            StringWriter sWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(sWriter);
            formatter.printHelp(writer, 80, "benno " + Benno.class.getPackage().getImplementationVersion(), "Commandline usage:", options, 1, 1, "Unexpected exception:" + exp.getMessage(), true);
            writer.flush();
            String message = sWriter.toString();
            System.err.println(message);
            LOGGER.fatal((Object)message);
            config = null;
        }
        if (config != null) {
            this.benno = null;
            this.benno = new Benno(config, readOnly, (IMailServiceHost)this);
            if (this.benno != null) {
                success = true;
                if (this.managementPort == 0) {
                    this.managementPort = config.managementPort;
                }
                this.managementAddress = cmdlineAddress == "0" ? config.managementAddress : cmdlineAddress;
            }
        }
        return success;
    }

    public IMailService registerService(IMailService service) {
        boolean isNew = true;
        for (IMailService existingService : this.services) {
            if (!existingService.equals(service)) continue;
            service = existingService;
            isNew = false;
        }
        if (isNew) {
            this.services.add(service);
        }
        return service;
    }

    public void start() {
        LOGGER.info((Object)("Starting management server on " + this.managementAddress + ":" + Integer.toString(this.managementPort)));
        try {
            Runtime.getRuntime().addShutdownHook((Thread)new BennoShutdownInterceptor((IBennoApplication)this));
            this.managementSocket = new ServerSocket(this.managementPort, 0, InetAddress.getByName(this.managementAddress));
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Could not open management interface on port " + this.managementAddress + ":" + Integer.toString(this.managementPort)), (Throwable)ex);
            System.err.println("Could not open management interface on port " + this.managementAddress + ":" + Integer.toString(this.managementPort));
            System.err.println(ex);
            System.exit(255);
        }
        if (this.managementSocket != null) {
            block6: {
                this.startServices();
                try {
                    while (this.managementSocket.isBound()) {
                        new Thread(new ManagementClient(this, this.managementSocket.accept())).run();
                    }
                }
                catch (Exception ex) {
                    LOGGER.info((Object)"Managementsocket closed");
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug((Object)"Socket exception ", (Throwable)ex);
                }
            }
            this.shutDown();
        }
    }

    public void startServices() {
        for (IMailService service : this.services) {
            service.start();
        }
    }

    public void stopServices() {
        for (IMailService service : this.services) {
            service.stop();
        }
    }

    public void listServices(PrintWriter out) {
        for (IMailService service : this.services) {
            out.print(service.toString());
            out.print(": ");
            out.println(service.getState());
        }
    }

    void listArchives(PrintWriter out) {
        this.benno.listArchives(out);
    }

    void optimizeIndex(String name, PrintWriter out) {
        this.benno.optimizeIndex(name, out);
    }

    public void shutDown() {
        try {
            if (this.managementSocket != null) {
                this.managementSocket.close();
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Error closing management socket", (Throwable)ex);
        }
        finally {
            this.stopServices();
        }
    }

    public String getIdentifier() {
        return "Bennoarchive " + this.benno.getIdentifier();
    }

    public void setBenno(Benno benno) {
        this.benno = benno;
    }

    public Benno getBenno() {
        return this.benno;
    }
}

