/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoarchive;

import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.bennoarchive.BennoArchive;
import de.lwsystems.mailarchive.bennoarchive.archive.ContainerTools;
import de.lwsystems.mailarchive.bennoarchive.directory.RemoveDirectory;
import de.lwsystems.mailarchive.bennoarchive.exception.NoPermissionToDeleteException;
import de.lwsystems.mailarchive.bennoarchive.exception.PasswordFileNotFoundException;
import de.lwsystems.mailarchive.bennoarchive.exception.PasswordNotMatchException;
import de.lwsystems.mailarchive.bennoarchive.removedocument.RemoveAuthorization;
import de.lwsystems.mailarchive.bennoarchive.removedocument.RemoveDocumentIndex;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.log.LogClass;
import de.lwsystems.mailarchive.log.RemoveLogClass;
import de.lwsystems.mailarchive.maildocument.RemovedMailDocument;
import de.lwsystems.mailarchive.remove.RemoveDocument;
import de.lwsystems.mailarchive.utils.BennoBuildTime;
import de.lwsystems.mailarchive.utils.BennoVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManagementClient
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(ManagementClient.class);
    private final BennoArchive archive;
    private final Socket client;
    private boolean running = false;
    private RemoveDocument removeDocument;
    private boolean isRemoveIndexActive = false;
    private boolean isRemoveLogActive = false;
    private boolean authenticatedForRemove = false;
    private Optional<String> bennoMailId = Optional.empty();

    protected ManagementClient(BennoArchive archive, Socket client) {
        this.archive = archive;
        this.client = client;
    }

    @Override
    public void run() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            PrintWriter out = new PrintWriter(this.client.getOutputStream(), true);
            String hostname = "Unknown";
            String ip = "Unknown";
            try {
                InetAddress local = InetAddress.getLocalHost();
                ip = local.getHostAddress();
                hostname = local.getHostName();
            }
            catch (UnknownHostException local) {
                // empty catch block
            }
            this.running = true;
            while (this.running) {
                try {
                    this.handleManagementCommand(in, out);
                    if (this.running) continue;
                    this.client.close();
                }
                catch (IOException e) {
                    this.running = false;
                    this.client.close();
                }
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Initialization of management client failed", (Throwable)ex);
        }
    }

    private void printManagementHelp(PrintWriter out) {
        out.println("quit                            End this management session");
        out.println("stop                            Stop this mailarchive server");
        out.println("show info                       Show information about this installation");
        out.println("list archives                   List archives");
        out.println("list files                      List files in inbox");
        out.println("list services                   List services");
        out.println("start services                  Start services");
        out.println("stop services                   Stop services");
    }

    public void initiateRemoveMailFromIndex(BufferedReader in) throws IOException {
        this.handleManagementCommand(in, new PrintWriter(this.client.getOutputStream(), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleManagementCommand(BufferedReader in, PrintWriter out) {
        block35: {
            try {
                BennoConfig bennoConfig = this.archive.getBenno().getConfig();
                StringBuilder everything = new StringBuilder();
                String command = in.readLine();
                if (command.equals("stop")) {
                    out.println("Goodbye!");
                    this.running = false;
                    this.archive.shutDown();
                    break block35;
                }
                if (command.equals("quit")) {
                    this.running = false;
                    break block35;
                }
                if (command.equals("help")) {
                    this.printManagementHelp(out);
                    break block35;
                }
                if (command.equals("show info")) {
                    out.println("bennoarchive: " + BennoVersion.archiveVersion() + " (" + BennoBuildTime.archiveBuildTime() + ")");
                    out.println("bennocore: " + BennoVersion.coreVersion() + " (" + BennoBuildTime.coreBuildTime() + ")");
                    out.println(this.archive.getConfigString());
                    break block35;
                }
                if (command.equals("list archives")) {
                    this.archive.listArchives(out);
                    break block35;
                }
                if (command.equals("list services")) {
                    this.archive.listServices(out);
                    break block35;
                }
                if (command.equals("start services")) {
                    out.println("Starting services...");
                    this.archive.startServices();
                    this.archive.listServices(out);
                    break block35;
                }
                if (command.equals("stop services")) {
                    out.println("Stopping services...");
                    this.archive.stopServices();
                    this.archive.listServices(out);
                    break block35;
                }
                if (command.equals("list files")) {
                    List archiveConfigs = bennoConfig.getArchiveGenerator().getArchives();
                    ArrayList checkedInboxes = new ArrayList();
                    archiveConfigs.forEach(archiver -> archiver.getServices().forEach(watcher -> {
                        block8: {
                            try {
                                if (checkedInboxes.contains(watcher.getDirectory())) break block8;
                                try (Stream<Path> inbox = Files.list(Paths.get(watcher.getDirectory(), new String[0]));){
                                    out.println(watcher.getDirectory() + " : " + inbox.count());
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }));
                    break block35;
                }
                if (command.equals("logdelete")) {
                    this.isRemoveLogActive = true;
                    this.removeDocument = RemoveDocument.getInstance((String)"logdelete");
                    this.removeDocument.activateLogDelete();
                    break block35;
                }
                if (command.equals("delindex")) {
                    this.isRemoveIndexActive = true;
                    this.removeDocument = RemoveDocument.getInstance((String)"delindex");
                    break block35;
                }
                if (this.isRemoveLogActive) {
                    if (this.authenticatedForRemove) {
                        if (!this.bennoMailId.isPresent()) {
                            this.bennoMailId = Optional.of(command.toUpperCase());
                        } else {
                            String mailId = this.bennoMailId.get();
                            IContainer myContainer = ContainerTools.getContainer(command, this.archive.getBenno());
                            RemoveDocumentIndex removeDocumentIndex = new RemoveDocumentIndex(myContainer, this.bennoMailId);
                            RemovedMailDocument myDoc = removeDocumentIndex.getMailFromRepo();
                            if (myDoc != null) {
                                out.println("OK: Mail reserved for delete from repo: " + myContainer.getIdentifier() + "/" + mailId);
                                this.removeDocument.reserveDocumentForRemoving(myDoc);
                            } else {
                                out.println("WARN: Mail is not present in repo: " + myContainer.getIdentifier() + "/" + mailId);
                            }
                            this.bennoMailId = Optional.empty();
                            this.running = false;
                        }
                    } else {
                        RemoveAuthorization removeAuthorization = new RemoveAuthorization(bennoConfig.getPasswordFile(), bennoConfig.isDeletePermission());
                        try {
                            this.authenticatedForRemove = removeAuthorization.checkAuthorizationForDeleting(command);
                        }
                        catch (NoPermissionToDeleteException | PasswordFileNotFoundException | PasswordNotMatchException ex) {
                            out.println(ex.getMessage());
                            this.running = false;
                        }
                    }
                    break block35;
                }
                if (this.isRemoveIndexActive) {
                    if (this.authenticatedForRemove) {
                        if (!this.bennoMailId.isPresent()) {
                            this.bennoMailId = Optional.of(command.toUpperCase());
                            break block35;
                        }
                        IContainer myContainer = ContainerTools.getContainer(command, this.archive.getBenno());
                        RemoveDocumentIndex removeDocumentIndex = new RemoveDocumentIndex(myContainer, this.bennoMailId);
                        if (!removeDocumentIndex.existsDocumentInIndex()) {
                            out.println("ERROR: Mail " + myContainer.getIdentifier() + "/" + removeDocumentIndex.getBennoMailId() + " is not present in index. Nothing is deleted.");
                        } else {
                            RemovedMailDocument myDoc = removeDocumentIndex.getMailFromRepo();
                            try {
                                RemoveDirectory removeDirectory = new RemoveDirectory(myContainer.getBoxGenerator().getState().getActualBox().getRepoPath());
                                LogClass removeLogClass = RemoveLogClass.getInstance((String)myContainer.getIdentifier(), (String)removeDirectory.getRemoveDirectory().toAbsolutePath().toString());
                                removeLogClass.addEntry(new String[]{removeDocumentIndex.getBennoMailId()});
                                if (!this.removeDocument.existsDocumentInStack(myDoc)) {
                                    this.removeDocument.reserveDocumentForRemoving(myDoc);
                                    out.println("OK: Mail reserved for delete from index: " + myContainer.getIdentifier() + "/" + removeDocumentIndex.getBennoMailId());
                                    LOGGER.info("DELETE entry from index: " + myContainer.getIdentifier() + "/" + removeDocumentIndex.getBennoMailId());
                                } else {
                                    out.println("ERROR: Mail exists in stack: " + myContainer.getIdentifier() + "/" + removeDocumentIndex.getBennoMailId());
                                }
                            }
                            catch (IOException ex) {
                                out.println(ex.getMessage());
                                this.running = false;
                            }
                            this.bennoMailId = Optional.empty();
                        }
                        this.running = false;
                        break block35;
                    }
                    RemoveAuthorization removeAuthorization = new RemoveAuthorization(bennoConfig.getPasswordFile(), bennoConfig.isDeletePermission());
                    try {
                        this.authenticatedForRemove = removeAuthorization.checkAuthorizationForDeleting(command);
                    }
                    catch (NoPermissionToDeleteException | PasswordFileNotFoundException | PasswordNotMatchException ex) {
                        out.println(ex.getMessage());
                        this.running = false;
                    }
                    break block35;
                }
                out.println("Unknown command \"" + command + "\"");
                this.printManagementHelp(out);
            }
            catch (Throwable exception) {
                out.println(exception.getMessage());
                this.running = false;
            }
        }
    }

    public void stop() {
        this.running = false;
    }
}

