/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoarchive.removedocument;

import de.lwsystems.mailarchive.bennoarchive.exception.NoPermissionToDeleteException;
import de.lwsystems.mailarchive.bennoarchive.exception.PasswordFileNotFoundException;
import de.lwsystems.mailarchive.bennoarchive.exception.PasswordNotMatchException;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class RemoveAuthorization {
    private Path archiveSecretFile;
    private boolean deletePermission;
    private String secretPassword;
    private boolean existsSecretFile = true;

    public RemoveAuthorization(String passwordFilePath, boolean deletePermission) {
        this.archiveSecretFile = Paths.get(passwordFilePath, new String[0]);
        this.deletePermission = deletePermission;
        this.existsSecretFile();
    }

    private void existsSecretFile() {
        if (!Files.exists(this.archiveSecretFile, new LinkOption[0])) {
            this.existsSecretFile = false;
        } else {
            this.setSecretPassword();
        }
    }

    private void setSecretPassword() {
        try (BufferedReader archiveSecret = Files.newBufferedReader(this.archiveSecretFile);){
            String password = archiveSecret.readLine();
            if (password != null) {
                this.secretPassword = password;
            }
        }
        catch (IOException e) {
            this.secretPassword = null;
        }
    }

    public String getSecretPassword() {
        return this.secretPassword;
    }

    public boolean checkAuthorizationForDeleting(String inputPassword) throws PasswordNotMatchException, PasswordFileNotFoundException, NoPermissionToDeleteException {
        if (this.existsSecretFile) {
            if (this.deletePermission) {
                if (this.secretPassword.equals(inputPassword)) {
                    return true;
                }
                throw new PasswordNotMatchException(inputPassword);
            }
            throw new NoPermissionToDeleteException();
        }
        throw new PasswordFileNotFoundException();
    }
}

