/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoarchive;

import de.lwsystems.mailarchive.bennoarchive.BennoArchive;
import de.lwsystems.mailarchive.utils.License;
import de.lwsystems.mailarchive.utils.RunUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class ManagementClient
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ManagementClient.class);
    private final BennoArchive archive;
    private final Socket client;
    private boolean running = false;

    protected ManagementClient(BennoArchive archive, Socket client) {
        this.archive = archive;
        this.client = client;
    }

    @Override
    public void run() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            PrintWriter out = new PrintWriter(this.client.getOutputStream(), true);
            String hostname = "Unknown";
            String ip = "Unknown";
            try {
                InetAddress local = InetAddress.getLocalHost();
                ip = local.getHostAddress();
                hostname = local.getHostName();
            }
            catch (UnknownHostException local) {
                // empty catch block
            }
            out.println("Benno mailarchive on " + hostname + " (" + ip + ") Version " + "2.1.6-SNAPSHOT");
            this.running = true;
            while (this.running) {
                try {
                    this.handleManagementCommand(in, out);
                    if (this.running) continue;
                    this.client.close();
                }
                catch (IOException e) {
                    this.running = false;
                    this.client.close();
                }
            }
        }
        catch (IOException ex) {
            LOGGER.warn((Object)"Initialization of management client failed", (Throwable)ex);
        }
    }

    private void printManagementHelp(PrintWriter out) {
        out.println("quit                            End this management session");
        out.println("stop                            Stop this mailarchive server");
        out.println("show info                       Show information about this installation");
        out.println("list archives                   List archives");
        out.println("list services                   List services");
        out.println("start services                  Start services");
        out.println("stop services                   Stop services");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleManagementCommand(BufferedReader in, PrintWriter out) {
        try {
            String command = in.readLine();
            if (command.equals("stop")) {
                out.println("Goodbye!");
                this.running = false;
                this.archive.shutDown();
            } else if (command.equals("quit")) {
                out.println("Goodbye!");
                this.running = false;
            } else if (command.equals("help")) {
                this.printManagementHelp(out);
            } else if (command.equals("show info")) {
                out.println("Benno MailArchiv");
                out.println("  Host-Info: " + new License().getHostInfo());
                out.println("  Build-Info: " + RunUtil.buildInfo());
            } else if (command.equals("list archives")) {
                this.archive.listArchives(out);
            } else if (command.equals("list services")) {
                this.archive.listServices(out);
            } else if (command.equals("start services")) {
                out.println("Starting services...");
                this.archive.startServices();
                this.archive.listServices(out);
            } else if (command.equals("stop services")) {
                out.println("Stopping services...");
                this.archive.stopServices();
                this.archive.listServices(out);
            } else {
                out.println("Unknown command \"" + command + "\"");
                this.printManagementHelp(out);
            }
        }
        catch (Throwable exception) {
            out.println(exception.getMessage());
            this.running = false;
        }
        finally {
            out.println();
        }
    }

    public void stop() {
        this.running = false;
    }
}

