#!/bin/sh
# postinst script for benno-archive
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    configure)
    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

set +e
chown --silent benno.benno /var/log/benno
chown --silent benno.benno /srv/benno/archive
chown --silent benno.benno /srv/benno/inbox
chmod --silent 2770 /srv/benno/inbox
set -e

if [ -x "/etc/init.d/benno-archive" ]; then
	update-rc.d benno-archive defaults >/dev/null
	#if [ -x "`which invoke-rc.d 2>/dev/null`" ]; then
	#	invoke-rc.d benno-archive start
	#else
    set +e
    /etc/init.d/benno-archive start
	#fi
    # Get System Info
    echo -n "Wait for archive "
    for i  in 1 1 2 2 2 2; do
        echo -n "."
        SYSTEMINFO=$(/bin/echo -e 'show info\nquit'|nc localhost 2555 2>/dev/null)
        if [ "${SYSTEMINFO}x" != x ];then break; fi
        sleep $i
    done
    echo ""
    IPATTERN=$(/bin/echo "$SYSTEMINFO"|grep ImportPattern|cut -d: -f2)
    if [ "${IPATTERN}x" != x ];then
        INBOXDIR=$(dirname $IPATTERN)
    else
        INBOXDIR=/srv/benno/inbox
    fi
    INSTALLDATE=$(date --rfc-2822)
    INSTALLTS=$(date +%s)
    ( 
      echo "From: benno-archive@sys.benno-mailarchiv.de"
      echo "To: benno-system@sys.benno-mailarchiv.de"
      echo "X-BENNO-System-Recipient: <benno-system@sys.benno-mailarchiv.de>"
      echo "Subject: Benno MailArchiv Installation"
      echo "Date: $INSTALLDATE"
      echo ""
      echo "$SYSTEMINFO"
    ) > $INBOXDIR/installinfo_${INSTALLTS}.tmp

    /bin/ln "$INBOXDIR/installinfo_${INSTALLTS}.tmp" "$INBOXDIR/installinfo_${INSTALLTS}.eml"
    /bin/rm "$INBOXDIR/installinfo_${INSTALLTS}.tmp"
fi

exit 0
