#!/bin/sh
# preinst script for benno-archive
#

set -e

# summary of how this script can be called:
#        * <new-preinst> `install'
#        * <new-preinst> `install' <old-version>
#        * <new-preinst> `upgrade' <old-version>
#        * <old-preinst> `abort-upgrade' <new-version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    install|upgrade)
        [ -z "$SERVER_HOME" ] && SERVER_HOME=/srv/benno
        [ -z "$SERVER_USER" ] && SERVER_USER=benno
        [ -z "$SERVER_GROUP" ] && SERVER_GROUP=benno
        [ -z "$SERVER_LOG" ] && SERVER_LOG=/var/log/benno
        [ -z "$SERVER_CACHE" ] && SERVER_CACHE=/var/cache/benno-archive

        if ! getent group | grep -q "^$SERVER_GROUP:" ; then
            echo -n "Adding group $SERVER_GROUP.."
            addgroup --quiet --system $SERVER_GROUP 2>/dev/null ||true
            echo "..done"
        fi

        test -d $SERVER_HOME || mkdir $SERVER_HOME

        if ! getent passwd | grep -q "^$SERVER_USER:"; then
            echo -n "Adding system user $SERVER_USER.."
            adduser --quiet --system --ingroup $SERVER_GROUP --no-create-home \
                    --home /srv/benno \
                    --disabled-password $SERVER_USER 2>/dev/null || true
            echo "..done"
        fi
        # 5. adjust file and directory permissions
        if ! dpkg-statoverride --list $SERVER_HOME >/dev/null
        then
            chown $SERVER_USER:$SERVER_GROUP $SERVER_HOME
            chmod u=rwx,g=rx,o=rx $SERVER_HOME
        fi

        test -d $SERVER_LOG || mkdir $SERVER_LOG
        if ! dpkg-statoverride --list $SERVER_LOG >/dev/null
        then
            chown $SERVER_USER:$SERVER_GROUP $SERVER_LOG
            chmod u=rwx,g=rwx,o= $SERVER_LOG
        fi

        test -d $SERVER_CACHE || mkdir $SERVER_CACHE
        if ! dpkg-statoverride --list $SERVER_CACHE >/dev/null
        then
            chown $SERVER_USER:$SERVER_GROUP $SERVER_CACHE
            chmod u=rwx,g=rwx,o= $SERVER_CACHE
        fi

    ;;

    abort-upgrade)
    ;;

    *)
        echo "preinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac
case "$1" in
    upgrade)
        /etc/init.d/benno-archive stop
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



exit 0
