/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoarchive.removedocument;

import de.lwsystems.mailarchive.bennoarchive.exception.PasswordFileNotFoundException;
import de.lwsystems.mailarchive.bennoarchive.exception.PasswordNotMatchException;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class RemoveAuthorization {
    private final Path archiveSecretFile = Paths.get("/etc/benno/archive.secret", new String[0]);
    private String secretPassword;
    private boolean existsSecretFile = true;

    public RemoveAuthorization() {
        this.existsSecretFile();
    }

    private void existsSecretFile() {
        if (!Files.exists(this.archiveSecretFile, new LinkOption[0])) {
            this.existsSecretFile = false;
        } else {
            this.setSecretPassword();
        }
    }

    private void setSecretPassword() {
        try (BufferedReader archiveSecret = Files.newBufferedReader(this.archiveSecretFile);){
            String password;
            while ((password = archiveSecret.readLine()) != null) {
                this.secretPassword = password;
            }
        }
        catch (IOException e) {
            this.secretPassword = null;
        }
    }

    public String getSecretPassword() {
        return this.secretPassword;
    }

    public boolean checkAuthorizationForDeleting(String inputPassword) throws PasswordNotMatchException, PasswordFileNotFoundException {
        if (this.existsSecretFile) {
            if (this.secretPassword.equals(inputPassword)) {
                return true;
            }
            throw new PasswordNotMatchException(inputPassword);
        }
        throw new PasswordFileNotFoundException();
    }
}

