#!/bin/sh
# postinst script for benno-archive
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    configure)
        set +e
        chown --silent benno.benno /var/log/benno
        chown --silent benno.benno /srv/benno/archive
        chown --silent benno.benno /srv/benno/inbox
        chmod --silent 2770 /srv/benno/inbox
        set -e

        update-rc.d benno-archive defaults >/dev/null
        set +e
        invoke-rc.d benno-archive start
        # Get System Info
        echo -n "Wait for archive "
        for i  in 1 1 2 2 2 2 5 5 5 5 10 10; do
            echo -n "."
            SYSTEMINFO=$(/bin/echo -e 'show info\nquit'|nc localhost 2555 2>/dev/null)
            if echo "${SYSTEMINFO}"|grep -q bennocore; then break; fi
            sleep $i
        done
        echo ""

        VARCHIVE=$(echo "$SYSTEMINFO"|tr -d '()'|grep bennoarchive|cut -d ' ' -f 3)
        VCORE=$(echo "$SYSTEMINFO" |tr -d '()'|grep bennocore|cut -d ' ' -f 3)
        IMPORTSERVICE=$(/bin/echo -e 'list services\nquit'|nc localhost 2555 2>/dev/null)
        IPATTERN=$(/bin/echo "$IMPORTSERVICE"|grep -m1 ImportPattern|perl -p -e 's/ImportPattern:\s+//')
        if [ "${IPATTERN}x" != x ];then
            INBOXDIR=$(dirname "$IPATTERN")
        else
            INBOXDIR=/srv/benno/inbox
        fi
        INSTALLDATE=$(date --rfc-2822)
        INSTALLTS=$(date +%s)
        ( 
          echo "From: benno-archive@sys.benno-mailarchiv.de"
          echo "To: benno-system@sys.benno-mailarchiv.de"
          echo "X-BENNO-System-Recipient: <benno-system@sys.benno-mailarchiv.de>"
          echo "X-BENNO-Archive-Version: $VARCHIVE"
          echo "X-BENNO-Core-Version: $VCORE"
          echo "Subject: Benno MailArchiv Installation"
          echo "Date: $INSTALLDATE"
          echo ""
          echo "$SYSTEMINFO"
        ) > $INBOXDIR/installinfo_${INSTALLTS}.tmp

        /bin/ln "$INBOXDIR/installinfo_${INSTALLTS}.tmp" "$INBOXDIR/installinfo_${INSTALLTS}.eml"
        /bin/rm "$INBOXDIR/installinfo_${INSTALLTS}.tmp"
    ;;
    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# Automatically added by dh_systemd_enable/13.3.4
if [ "$1" = "configure" ] || [ "$1" = "abort-upgrade" ] || [ "$1" = "abort-deconfigure" ] || [ "$1" = "abort-remove" ] ; then
	# This will only remove masks created by d-s-h on package removal.
	deb-systemd-helper unmask 'benno-archive.service' >/dev/null || true

	# was-enabled defaults to true, so new installations run enable.
	if deb-systemd-helper --quiet was-enabled 'benno-archive.service'; then
		# Enables the unit on first installation, creates new
		# symlinks on upgrades if the unit file has changed.
		deb-systemd-helper enable 'benno-archive.service' >/dev/null || true
	else
		# Update the statefile to add new symlinks (if any), which need to be
		# cleaned up on purge. Also remove old symlinks.
		deb-systemd-helper update-state 'benno-archive.service' >/dev/null || true
	fi
fi
# End automatically added section
# Automatically added by dh_installinit/13.3.4
if [ "$1" = "configure" ] || [ "$1" = "abort-upgrade" ] || [ "$1" = "abort-deconfigure" ] || [ "$1" = "abort-remove" ] ; then
	if [ -x "/etc/init.d/benno-archive" ]; then
		update-rc.d benno-archive defaults >/dev/null
		if [ -n "$2" ]; then
			_dh_action=restart
		else
			_dh_action=start
		fi
		invoke-rc.d benno-archive $_dh_action || exit 1
	fi
fi
# End automatically added section


exit 0


