/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive;

import de.lwsystems.mailarchive.commandline.CommandLineParameters;
import de.lwsystems.mailarchive.commandline.CommandLineReader;
import de.lwsystems.mailarchive.exception.IdNotFoundException;
import de.lwsystems.mailarchive.exception.MailAgeException;
import de.lwsystems.mailarchive.journal.DeleteIndexEntry;
import de.lwsystems.mailarchive.maildocument.EditMailDocument;
import de.lwsystems.mailarchive.maildocument.ReadMailDocument;
import de.lwsystems.mailarchive.maildocument.RemoveMailDocument;
import java.io.IOException;
import java.nio.file.Files;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.log4j.Logger;

public class BennoAdminTool {
    private static final Logger LOGGER = Logger.getLogger(BennoAdminTool.class);

    public static void main(String[] args) throws IdNotFoundException, MailAgeException, IOException {
        block22: {
            if (!System.getProperty("user.name").equals("root") && !System.getProperty("user.name").equals("benno")) {
                LOGGER.error("Only \"root\" or \"benno\" user can execute benno-archive-tool");
                System.exit(0);
            }
            CommandLineReader cliIndex = new CommandLineReader();
            CommandLine commandLine = cliIndex.parseOptions(args);
            cliIndex.getParameters(commandLine);
            CommandLineParameters commandLineParameters = cliIndex.getCommandLineParameters();
            ReadMailDocument readMailDocument = new ReadMailDocument();
            RemoveMailDocument removeMailDocument = new RemoveMailDocument();
            EditMailDocument editMailDocument = new EditMailDocument();
            boolean forceDelete = commandLineParameters.isForceDelete();
            if (commandLine.hasOption("DD")) {
                if (commandLineParameters.getTagKey() == null && !commandLineParameters.isDelete()) {
                    if (commandLineParameters.getIndexPath().exists() && commandLineParameters.getIndexPath().exists()) {
                        try {
                            removeMailDocument.removeDuplicateMailInIndex(readMailDocument, commandLineParameters);
                        }
                        catch (IOException e) {
                            LOGGER.error("Mail in repo path cannot be deleted ", e);
                        }
                    }
                } else {
                    LOGGER.error("Select -DD (delete duplicate) as single parameter");
                    System.exit(0);
                }
            } else if (commandLineParameters.getIndexPath().exists() && (commandLine.hasOption("maillist") || commandLine.hasOption("m"))) {
                if (commandLine.hasOption("m")) {
                    if (readMailDocument.existsMail("id", commandLineParameters.getMail(), forceDelete, commandLineParameters)) {
                        if (commandLineParameters.getTagKey() != null && !commandLineParameters.isDelete()) {
                            editMailDocument.addTagPairToDocument("id", commandLineParameters.getMail(), commandLineParameters, readMailDocument);
                        } else if (commandLineParameters.isDelete() && commandLineParameters.getTagKey() == null) {
                            removeMailDocument.removeMailInIndex("id", commandLineParameters.getMail(), commandLineParameters, new DeleteIndexEntry(commandLineParameters.getMail()), readMailDocument);
                        } else {
                            LOGGER.error("Select delete or tag as parameter, not both");
                            System.exit(0);
                        }
                    }
                } else if (commandLine.hasOption("maillist") && commandLineParameters.getMailList().length() > 0L) {
                    try {
                        Stream<String> mailLines = Files.lines(commandLineParameters.getMailList().toPath()).filter(s -> readMailDocument.existsMail("id", (String)s, forceDelete, commandLineParameters));
                        if (commandLineParameters.getTagKey() != null && !commandLineParameters.isDelete()) {
                            mailLines.forEach(s -> editMailDocument.addTagPairToDocument("id", (String)s, commandLineParameters, readMailDocument));
                            break block22;
                        }
                        if (commandLineParameters.isDelete() && commandLineParameters.getTagKey() == null) {
                            mailLines.forEach(s -> {
                                try {
                                    removeMailDocument.removeMailInIndex("id", (String)s, commandLineParameters, new DeleteIndexEntry((String)s), readMailDocument);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            });
                            break block22;
                        }
                        LOGGER.error("Select delete or tag as parameter, not both");
                        System.exit(0);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        System.exit(0);
                    }
                }
            } else {
                HelpFormatter helpFormatter = new HelpFormatter();
            }
        }
    }
}

