/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.commandline;

import java.io.File;
import java.time.LocalDate;
import org.apache.log4j.Logger;

public class CommandLineParameters {
    private static final Logger LOGGER = Logger.getLogger(CommandLineParameters.class);
    private String indexOrMailDate = "IndexTS";
    private boolean delete = false;
    private boolean forceDelete = false;
    private File indexPath = null;
    private File repoPath = null;
    private File journalPath;
    private File mailList = null;
    private String mail = "";
    private Integer subDirs = null;
    private Integer subDirLen = null;
    private String tagKey = null;
    private String tagValue = null;
    private String fileExtension = "";
    private int journalYear = LocalDate.now().getYear();

    CommandLineParameters() {
    }

    public File getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(File indexPath) {
        if (!indexPath.exists()) {
            LOGGER.error("Index path (" + indexPath.toString() + ") doesn't exist");
            System.exit(0);
        }
        this.indexPath = indexPath;
    }

    public File getRepoPath() {
        return this.repoPath;
    }

    public void setRepoPath(File repoPath) {
        if (!repoPath.exists()) {
            LOGGER.error("Repo path (" + repoPath.toString() + ") doesn't exist");
            System.exit(0);
        }
        this.repoPath = repoPath;
    }

    public File getJournalPath() {
        return this.journalPath;
    }

    public void setJournalPath(File journalPath) {
        if (!journalPath.exists()) {
            LOGGER.error("Journal path  (" + journalPath.toString() + ")  doesn't exist");
            System.exit(0);
        }
        this.journalPath = journalPath;
    }

    public Integer getSubDirs() {
        return this.subDirs;
    }

    public void setSubDirs(Integer subDirs) {
        this.subDirs = subDirs;
    }

    public Integer getSubDirLen() {
        return this.subDirLen;
    }

    public void setSubDirLen(Integer subDirLen) {
        this.subDirLen = subDirLen;
    }

    public File getMailList() {
        return this.mailList;
    }

    public void setMailList(File mailList) {
        if (!mailList.exists()) {
            LOGGER.error("Maillist (" + mailList.toString() + ") doesn't exist");
            System.exit(0);
        }
        this.mailList = mailList;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isForceDelete() {
        return this.forceDelete;
    }

    public void setForceDelete(boolean forceDelete) {
        this.forceDelete = forceDelete;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getIndexOrMailDate() {
        return this.indexOrMailDate;
    }

    public void setIndexOrMailDate(String indexOrMailDate) {
        this.indexOrMailDate = indexOrMailDate;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getTagKey() {
        return this.tagKey;
    }

    public void setTagKey(String tagKey) {
        this.tagKey = tagKey;
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public void setTagValue(String tagValue) {
        this.tagValue = tagValue;
    }

    public int getJournalYear() {
        return this.journalYear;
    }

    public void setJournalYear(int journalYear) {
        this.journalYear = journalYear;
    }
}

