/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.commandline;

import de.lwsystems.mailarchive.commandline.CommandLineParameters;
import java.io.File;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

public class CommandLineReader {
    private CommandLineParser parser = new PosixParser();
    private CommandLineParameters commandLineParameters = new CommandLineParameters();
    private static final Logger LOGGER = Logger.getLogger(CommandLineReader.class);
    private Scanner scanner;
    private Options options;

    public CommandLineReader() {
        this.commandLineParameters.setSubDirs(3);
        this.commandLineParameters.setSubDirLen(2);
        this.commandLineParameters.setFileExtension(".gz");
        this.options = new Options();
        OptionBuilder.withArgName("MAIL");
        OptionBuilder.withLongOpt("mailid");
        OptionBuilder.withDescription("Select mailid");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        this.options.addOption(OptionBuilder.create("m"));
        OptionBuilder.withArgName("MAILLIST");
        OptionBuilder.withLongOpt("maillist");
        OptionBuilder.withDescription("Select maillist file with mailids");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName("MAILDATE");
        OptionBuilder.withLongOpt("maildate");
        OptionBuilder.withDescription("Take as retention period parameter the mail date");
        this.options.addOption(OptionBuilder.create("md"));
        OptionBuilder.withArgName("DELETE");
        OptionBuilder.withLongOpt("delete");
        OptionBuilder.withDescription("Delete mails from index");
        this.options.addOption(OptionBuilder.create("D"));
        OptionBuilder.withArgName("FORCE");
        OptionBuilder.withLongOpt("force");
        OptionBuilder.withDescription("Delete mails without checking retention period");
        this.options.addOption(OptionBuilder.create("f"));
        OptionBuilder.withArgName("INDEXPATH");
        OptionBuilder.withLongOpt("indexpath");
        OptionBuilder.withDescription("Path of Index directory (default: /srv/benno/archive/index)");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        this.options.addOption(OptionBuilder.create("i"));
        OptionBuilder.withArgName("TAGKEY");
        OptionBuilder.withLongOpt("tagkey");
        OptionBuilder.withDescription("Set Tagkey name here (Currently only invisible possible)");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        this.options.addOption(OptionBuilder.create("tk"));
        OptionBuilder.withArgName("TAGVALUE");
        OptionBuilder.withLongOpt("tagvalue");
        OptionBuilder.withDescription("Set Tagvalue name here (Currently only 1 or 0 possible)");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        this.options.addOption(OptionBuilder.create("tv"));
        OptionBuilder.withArgName("INDEXPATH");
        OptionBuilder.withLongOpt("indexpath");
        OptionBuilder.withDescription("Path of Index directory (default: /srv/benno/archive/index)");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        this.options.addOption(OptionBuilder.create("i"));
        OptionBuilder.withArgName("REPOPATH");
        OptionBuilder.withLongOpt("repopath");
        OptionBuilder.withDescription("Path of Repo directory (default: /srv/benno/archive/repo)");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        this.options.addOption(OptionBuilder.create("r"));
        OptionBuilder.withArgName("JOURNALPATH");
        OptionBuilder.withLongOpt("journalpath");
        OptionBuilder.withDescription("Path of Journal directory (default: /srv/benno/archive/repo)");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        this.options.addOption(OptionBuilder.create("j"));
        OptionBuilder.withArgName("SUBDIRS");
        OptionBuilder.withLongOpt("subdirs");
        OptionBuilder.withDescription("Set the total amount of Subdirectories");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        this.options.addOption(OptionBuilder.create("s"));
        OptionBuilder.withArgName("SUBDIRLEN");
        OptionBuilder.withLongOpt("subdirlen");
        OptionBuilder.withDescription("Subdirlength");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        this.options.addOption(OptionBuilder.create("sl"));
        OptionBuilder.withArgName("FILEEXTENSION");
        OptionBuilder.withLongOpt("fileextension");
        OptionBuilder.withDescription("File extension of the mail");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        this.options.addOption(OptionBuilder.create("fe"));
        OptionBuilder.withArgName("JOURNALYEAR");
        OptionBuilder.withLongOpt("journalyear");
        OptionBuilder.withDescription("Current year to determine the current.journal");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        this.options.addOption(OptionBuilder.create("jy"));
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("print this description");
        this.options.addOption(OptionBuilder.create("h"));
        OptionBuilder.withArgName("DELETEDUPLICATE");
        OptionBuilder.withLongOpt("deleteduplicate");
        OptionBuilder.withDescription("Delete duplicate mails from index");
        this.options.addOption(OptionBuilder.create("DD"));
    }

    public CommandLine parseOptions(String[] args) {
        try {
            return this.parser.parse(this.options, args, true);
        }
        catch (ParseException pe) {
            LOGGER.error("Commandline Parameters cannot be parsed");
            pe.printStackTrace();
            return null;
        }
    }

    public void getParameters(CommandLine cmdl) {
        if (cmdl.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar benno-archive-tool.jar", this.options);
            Runtime.getRuntime().exit(0);
        } else {
            if (cmdl.hasOption("i")) {
                try {
                    this.commandLineParameters.setIndexPath(new File(cmdl.getParsedOptionValue("i").toString()));
                }
                catch (ParseException pe) {
                    LOGGER.error("Index path does not exist or was not specified");
                    pe.printStackTrace();
                }
            } else {
                this.commandLineParameters.setIndexPath(new File("/srv/benno/archive/index"));
            }
            LOGGER.info("Index path is: " + this.commandLineParameters.getIndexPath());
            if (cmdl.hasOption("r")) {
                try {
                    this.commandLineParameters.setRepoPath(new File(cmdl.getParsedOptionValue("r").toString()));
                }
                catch (ParseException pe) {
                    LOGGER.error("Repo path does not exist or was not specified");
                    pe.printStackTrace();
                }
            } else {
                this.commandLineParameters.setRepoPath(new File("/srv/benno/archive/repo"));
            }
            LOGGER.info("Repo path is: " + this.commandLineParameters.getRepoPath());
            if (cmdl.hasOption("j")) {
                try {
                    this.commandLineParameters.setJournalPath(new File(cmdl.getParsedOptionValue("j").toString()));
                }
                catch (ParseException pe) {
                    LOGGER.error("Journal path does not exist or was not specified");
                    pe.printStackTrace();
                }
            } else {
                this.commandLineParameters.setJournalPath(this.commandLineParameters.getRepoPath());
            }
            LOGGER.info("Journal path is: " + this.commandLineParameters.getJournalPath());
            if (this.commandLineParameters.getIndexPath().exists()) {
                if (cmdl.hasOption("m")) {
                    try {
                        this.commandLineParameters.setMail(cmdl.getParsedOptionValue("m").toString());
                        LOGGER.info("MailID is: " + this.commandLineParameters.getMail());
                    }
                    catch (ParseException pe) {
                        LOGGER.error("MailID is missing");
                        pe.printStackTrace();
                    }
                }
                if (cmdl.hasOption("maillist")) {
                    try {
                        this.commandLineParameters.setMailList(new File((String)cmdl.getParsedOptionValue("maillist")));
                        LOGGER.info("Text file with MailIDs was transferred");
                    }
                    catch (ParseException pe) {
                        LOGGER.error("Text file with MailIDs is missing");
                        pe.printStackTrace();
                    }
                }
            }
            if (cmdl.hasOption("s")) {
                try {
                    this.commandLineParameters.setSubDirs(Integer.parseInt(cmdl.getParsedOptionValue("s").toString()));
                }
                catch (ParseException pe) {
                    LOGGER.error("Subdir value is not a number");
                    pe.printStackTrace();
                }
            }
            LOGGER.info("Number of subdirs are: " + this.commandLineParameters.getSubDirs());
            if (cmdl.hasOption("sl")) {
                try {
                    this.commandLineParameters.setSubDirLen(Integer.parseInt(cmdl.getParsedOptionValue("sl").toString()));
                }
                catch (ParseException pe) {
                    LOGGER.error("Subdir length value is not a number");
                    pe.printStackTrace();
                }
            }
            LOGGER.info("Length of subdirs is: " + this.commandLineParameters.getSubDirLen());
            if (cmdl.hasOption("fe")) {
                try {
                    this.commandLineParameters.setFileExtension(cmdl.getParsedOptionValue("fe").toString());
                }
                catch (ParseException pe) {
                    LOGGER.error("File extension is not a valid value");
                    pe.printStackTrace();
                }
            }
            LOGGER.info("File extension is: " + this.commandLineParameters.getFileExtension());
            if (cmdl.hasOption("tk")) {
                if (cmdl.getOptionValue("tk").equals("invisible")) {
                    try {
                        this.commandLineParameters.setTagKey(cmdl.getParsedOptionValue("tk").toString());
                        LOGGER.info("Tag key name is: " + this.commandLineParameters.getTagKey());
                    }
                    catch (ParseException pe) {
                        LOGGER.error("Tag key name is missing");
                        pe.printStackTrace();
                        System.exit(0);
                    }
                    if (cmdl.hasOption("tv")) {
                        if (cmdl.getOptionValue("tv").equals("1") || cmdl.getOptionValue("tv").equals("0")) {
                            try {
                                this.commandLineParameters.setTagValue(cmdl.getParsedOptionValue("tv").toString());
                                LOGGER.info("Tag Value is: " + this.commandLineParameters.getTagValue());
                                this.commandLineParameters.setForceDelete(true);
                            }
                            catch (ParseException pe) {
                                LOGGER.error("Tag value is missing");
                                pe.printStackTrace();
                                System.exit(0);
                            }
                        } else {
                            LOGGER.error("Tag value for invisible must be 1 or 0");
                            System.exit(0);
                        }
                    }
                } else {
                    LOGGER.error("Tag key name must be invisible");
                    System.exit(0);
                }
            }
            if (cmdl.hasOption("jy")) {
                try {
                    this.commandLineParameters.setJournalYear(Integer.parseInt(cmdl.getParsedOptionValue("jy").toString()));
                }
                catch (ParseException pe) {
                    LOGGER.error("Journal year is not a number");
                    pe.printStackTrace();
                }
            }
            LOGGER.info("Current journal is in year box: " + this.commandLineParameters.getJournalYear());
            if (cmdl.hasOption("md")) {
                this.commandLineParameters.setIndexOrMailDate("Date");
            }
            if (cmdl.hasOption("f")) {
                this.commandLineParameters.setForceDelete(true);
                LOGGER.info("Delete mail/s without checking retention period is enabled");
            }
            if (cmdl.hasOption("D")) {
                String input;
                Scanner s = new Scanner(System.in);
                do {
                    System.out.print("Are you sure you want to delete the selected mails from the archive? You do this at your own risk. Type the word delete and press enter, or type exit and leave the program: ");
                    input = s.next();
                    if (!input.equals("exit")) continue;
                    LOGGER.info("Close the program");
                    System.exit(0);
                } while (!input.equals("delete"));
                this.commandLineParameters.setDelete(true);
                LOGGER.info("Delete mail/s is enabled");
            }
        }
    }

    public CommandLineParameters getCommandLineParameters() {
        return this.commandLineParameters;
    }

    public Options getOptions() {
        return this.options;
    }
}

