/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.index;

import de.lwsystems.mailarchive.index.LuceneIndex;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.AlreadyClosedException;

public class LuceneIndexManipulate
extends LuceneIndex {
    private IndexWriter indexWriter;

    public LuceneIndexManipulate(File path) {
        super(path);
        IndexWriterConfig config = new IndexWriterConfig(this.luceneVersion, new ClassicAnalyzer(this.luceneVersion));
        config.setRAMBufferSizeMB(16.0);
        config.setMaxBufferedDocs(1000);
        try {
            this.indexWriter = new IndexWriter(this.getIndexDirectory(), config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateIndex(String field, String termText, Document document) {
        try {
            Term term = new Term(field, termText);
            this.indexWriter.updateDocument(term, document);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeDocumentInIndex(String field, String termText) {
        Term term = new Term(field, termText);
        try {
            this.indexWriter.deleteDocuments(term);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void closeIndex() {
        try {
            this.indexWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (AlreadyClosedException ex) {
            ex.printStackTrace();
        }
        super.closeIndex();
    }
}

