/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.index;

import de.lwsystems.mailarchive.index.LuceneIndex;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.AlreadyClosedException;

public class LuceneIndexRead
extends LuceneIndex {
    private IndexReader idxReader;
    private IndexSearcher idxSearcher;
    private int hitLimit = 1000;

    public LuceneIndexRead(File path) {
        super(path);
        try {
            this.idxReader = IndexReader.open(this.getIndexDirectory());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.idxSearcher = new IndexSearcher(this.idxReader);
    }

    public TopDocs indexSearch(String field, String termText) {
        Term term = new Term(field, termText);
        TermQuery query = new TermQuery(term);
        try {
            TopDocs docs = this.idxSearcher.search((Query)query, this.hitLimit);
            return docs;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public Document getDocumentByDocID(Integer docId) {
        try {
            Document document = this.idxSearcher.doc(docId);
            return document;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Document searchMailAndGetDocument(String field, String termText) {
        TopDocs docs = this.indexSearch(field, termText);
        ScoreDoc scoreDocs = docs.scoreDocs[0];
        try {
            Document document = this.idxSearcher.doc(scoreDocs.doc);
            return document;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean existsMailDocument(String field, String termText) {
        Document document = this.searchMailAndGetDocument(field, termText);
        return document != null;
    }

    public IndexReader getLuceneIndexReader() {
        return this.idxReader;
    }

    @Override
    public void closeIndex() {
        try {
            this.idxReader.close();
            this.idxSearcher.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (AlreadyClosedException ex) {
            ex.printStackTrace();
        }
        super.closeIndex();
    }
}

