/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.journal;

import de.lwsystems.mailarchive.journal.JournalEntry;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AbstractJournal {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.ROOT);

    public AbstractJournal() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    protected String formatEntry(JournalEntry entry) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.dateFormat.format(entry.getDate())).append(": (");
        stringBuilder.append(entry.getState().toString()).append(") ");
        stringBuilder.append(entry.getMessage());
        return stringBuilder.toString();
    }

    public abstract void addEntry(JournalEntry var1);
}

