/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.journal;

import de.lwsystems.mailarchive.journal.AbstractJournal;
import de.lwsystems.mailarchive.journal.JournalEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.log4j.Logger;

public class FSJournal
extends AbstractJournal {
    private File journalPath;
    private final String journalDirectoryName = "journal";
    protected static final String JOURNALSUFFIX = ".journal";
    protected static final String JOURNALFILE = "current";
    protected static final int BUFFERSIZE = 1024;
    private static final Logger LOGGER = Logger.getLogger(FSJournal.class);
    private final File directory;
    private File logfile;
    private String currentPart;

    public File getJournalPath() {
        return this.journalPath;
    }

    private File setJournalPath(File journalPath, String boxName) {
        return new File(journalPath.toString() + "/" + boxName + "/" + this.journalDirectoryName);
    }

    public FSJournal(File journalPath, String boxName) {
        block5: {
            this.journalDirectoryName = "journal";
            this.directory = this.setJournalPath(journalPath, boxName);
            this.logfile = this.getCurrentFile();
            if (this.logfile.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(this.logfile));
                    String firstLine = reader.readLine();
                    if (!firstLine.contains(": (SUCCESS) START      \"")) {
                        LOGGER.fatal("invalid Journal \"" + this.logfile.getAbsolutePath() + "\"");
                        this.currentPart = "Invalid";
                        break block5;
                    }
                    this.currentPart = firstLine.split("\"")[1];
                }
                catch (Throwable ex) {
                    LOGGER.fatal("invalid Journal \"" + this.logfile.getAbsolutePath() + "\"", ex);
                    this.currentPart = "Invalid";
                }
            } else {
                LOGGER.error("current.journal file not exists");
                System.exit(0);
            }
        }
    }

    @Override
    public synchronized void addEntry(JournalEntry entry) {
        try {
            this.writeEntry(entry);
        }
        catch (IOException ex) {
            LOGGER.fatal("Unable to write Journalentry \"" + entry.toString(), ex);
        }
    }

    private void writeEntry(JournalEntry entry) throws IOException {
        OutputStreamWriter journalWriter = new OutputStreamWriter(new FileOutputStream(this.logfile, true));
        journalWriter.write(this.formatEntry(entry));
        journalWriter.write("\n");
        journalWriter.flush();
        journalWriter.close();
    }

    protected File getCurrentFile() {
        return new File(this.directory.getAbsolutePath() + File.separator + JOURNALFILE + JOURNALSUFFIX);
    }
}

