/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.journal;

import de.lwsystems.mailarchive.utils.Clock;
import java.util.Date;

public abstract class JournalEntry {
    private final Date date;
    private final JournalEntryState state;

    public JournalEntry(Date date, JournalEntryState state) {
        this.date = date;
        this.state = state;
    }

    public JournalEntry(JournalEntryState state) {
        this(Clock.getProvider().newDate(), state);
    }

    public final Date getDate() {
        return this.date;
    }

    public final JournalEntryState getState() {
        return this.state;
    }

    public abstract String getMessage();

    public StringBuilder appendMessage(StringBuilder stringbuilder) {
        stringbuilder.append(this.getMessage());
        return stringbuilder;
    }

    public String toString() {
        return this.date.toString() + " " + this.state.toString() + " " + this.getMessage();
    }

    public static enum JournalEntryState {
        SUCCESS,
        FAILED;

    }
}

