/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.maildocument;

import de.lwsystems.mailarchive.commandline.CommandLineParameters;
import de.lwsystems.mailarchive.index.LuceneIndexManipulate;
import de.lwsystems.mailarchive.journal.FSJournal;
import de.lwsystems.mailarchive.journal.HideMailEntry;
import de.lwsystems.mailarchive.journal.JournalEntry;
import de.lwsystems.mailarchive.journal.ShowMailEntry;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.ReadMailDocument;
import de.lwsystems.mailarchive.maildocument.RemoveMailDocument;
import de.lwsystems.mailarchive.utils.ModifyParameter;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class EditMailDocument
implements MailDocument {
    private static final Logger LOGGER = Logger.getLogger(RemoveMailDocument.class);

    public void addChangedDocumentToIndex(String field, String termText, Document document, CommandLineParameters clp, JournalEntry journalEntry) {
        HashMap<Object, Object> documentBoxAndId = new HashMap();
        documentBoxAndId = ModifyParameter.splitDocumentId(document.get("id"));
        FSJournal fsJournal = new FSJournal(clp.getJournalPath(), String.valueOf(clp.getJournalYear()));
        LuceneIndexManipulate luceneIndexManipulate = new LuceneIndexManipulate(clp.getIndexPath());
        luceneIndexManipulate.updateIndex(field, termText, document);
        luceneIndexManipulate.closeIndex();
        LOGGER.info("Mail Tag " + clp.getTagKey() + ":" + clp.getTagValue() + " added to mail " + document.get("id"));
        fsJournal.addEntry(journalEntry);
    }

    public void addTagPairToDocument(String field, String termText, CommandLineParameters clp, ReadMailDocument readMailDocument) {
        JournalEntry journalEntry;
        Document document = readMailDocument.getMailDocument(field, termText, clp.getIndexPath());
        System.out.println(document.get("invisible"));
        try {
            journalEntry = clp.getTagValue().equals("1") ? new HideMailEntry(document.get("id")) : new ShowMailEntry(document.get("id"));
        }
        catch (NullPointerException ex) {
            journalEntry = new ShowMailEntry(document.get("id"));
        }
        Field tagField = new Field(clp.getTagKey(), clp.getTagValue(), Field.Store.YES, Field.Index.ANALYZED);
        document.removeField(clp.getTagKey());
        document.add(tagField);
        this.addChangedDocumentToIndex(field, termText, document, clp, journalEntry);
    }
}

