/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.maildocument;

import de.lwsystems.mailarchive.commandline.CommandLineParameters;
import de.lwsystems.mailarchive.exception.IdNotFoundException;
import de.lwsystems.mailarchive.exception.MailAgeException;
import de.lwsystems.mailarchive.index.LuceneIndexRead;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.utils.ModifyParameter;
import java.io.File;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class ReadMailDocument
implements MailDocument {
    private int retentionPeriod = 10;
    private int dateTimePatternLength = 12;
    private static final Logger LOGGER = Logger.getLogger(ReadMailDocument.class);
    private String mailPath;
    private String fileToDelete;
    private String boxYear;

    private boolean existsMailAndIsRetentionPeriodOver(String field, String termText, File indexPath, String indexOrMailDate, boolean forceDelete) throws MailAgeException, IdNotFoundException {
        LuceneIndexRead luceneIndexRead = new LuceneIndexRead(indexPath);
        TopDocs docs = luceneIndexRead.indexSearch(field, termText);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
        int n = 0;
        ScoreDoc[] scoreDocArray = docs.scoreDocs;
        int n2 = scoreDocArray.length;
        if (n < n2) {
            LocalDate indexDate;
            ScoreDoc doc = scoreDocArray[n];
            Document thisDoc = luceneIndexRead.getDocumentByDocID(doc.doc);
            luceneIndexRead.closeIndex();
            LOGGER.debug("Mail found: " + thisDoc.get("id"));
            try {
                indexDate = LocalDate.parse(thisDoc.get(indexOrMailDate).substring(0, this.dateTimePatternLength), formatter);
            }
            catch (NullPointerException ex) {
                indexDate = LocalDate.now();
            }
            Period period = Period.between(LocalDate.now(), indexDate);
            if (period.getYears() > -this.retentionPeriod) {
                if (forceDelete) {
                    return true;
                }
                throw new MailAgeException(String.valueOf(period.getYears()) + "/" + this.retentionPeriod);
            }
            LOGGER.info("Mail retention period (" + period.getYears() + "/" + this.retentionPeriod + ") arrived: " + thisDoc.get("id"));
            return true;
        }
        throw new IdNotFoundException(termText);
    }

    public Document getMailDocument(String field, String termText, File indexPath) {
        LuceneIndexRead luceneIndexRead = new LuceneIndexRead(indexPath);
        return luceneIndexRead.searchMailAndGetDocument(field, termText);
    }

    public boolean existsMail(String field, String termText, boolean forceDelete, CommandLineParameters clp) {
        try {
            return this.existsMailAndIsRetentionPeriodOver(field, termText, clp.getIndexPath(), clp.getIndexOrMailDate(), forceDelete);
        }
        catch (MailAgeException e) {
            LOGGER.warn("Mail retention period not arrived (" + e.getMessage() + "): " + termText);
            return false;
        }
        catch (IdNotFoundException e) {
            LOGGER.warn("MailID not found: " + termText);
            return false;
        }
    }

    public String determineMailPath(Document doc, CommandLineParameters clp) {
        HashMap<Object, Object> documentBoxAndId = new HashMap();
        documentBoxAndId = ModifyParameter.splitDocumentId(doc.get("id"));
        String documentId = (String)documentBoxAndId.get("id");
        String subdirs = "";
        for (int i = 0; i < clp.getSubDirs(); ++i) {
            subdirs = subdirs + documentId.substring(0, clp.getSubDirLen()) + "/";
            documentId = documentId.substring(clp.getSubDirLen(), documentId.length());
        }
        this.mailPath = clp.getRepoPath() + "/" + (String)documentBoxAndId.get("box") + "/" + subdirs;
        this.fileToDelete = documentId + clp.getFileExtension();
        this.boxYear = (String)documentBoxAndId.get("box");
        return clp.getRepoPath() + "/" + (String)documentBoxAndId.get("box") + "/" + subdirs + documentId + clp.getFileExtension();
    }

    public String getMailPath() {
        return this.mailPath;
    }

    public String getFileToDelete() {
        return this.fileToDelete;
    }

    public String getBoxYear() {
        return this.boxYear;
    }
}

