/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.maildocument;

import de.lwsystems.mailarchive.commandline.CommandLineParameters;
import de.lwsystems.mailarchive.index.LuceneIndexManipulate;
import de.lwsystems.mailarchive.index.LuceneIndexRead;
import de.lwsystems.mailarchive.journal.DeleteDuplicateIndexEntry;
import de.lwsystems.mailarchive.journal.FSJournal;
import de.lwsystems.mailarchive.journal.JournalEntry;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.ReadMailDocument;
import de.lwsystems.mailarchive.repo.RemoveDirectoriesRepo;
import de.lwsystems.mailarchive.repo.RemoveMailRepo;
import de.lwsystems.mailarchive.utils.ModifyParameter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;

public class RemoveMailDocument
implements MailDocument {
    private LuceneIndexManipulate luceneIndexManipulate;
    private static final Logger LOGGER = Logger.getLogger(RemoveMailDocument.class);

    public void removeMailInIndex(String field, String termText, CommandLineParameters clp, JournalEntry journalEntry, ReadMailDocument readMailDocument) throws IOException {
        HashMap<Object, Object> documentBoxAndId = new HashMap();
        documentBoxAndId = ModifyParameter.splitDocumentId(termText);
        Document document = readMailDocument.getMailDocument(field, termText, clp.getIndexPath());
        if (document == null) {
            return;
        }
        FSJournal fsJournal = new FSJournal(clp.getJournalPath(), String.valueOf(clp.getJournalYear()));
        LuceneIndexManipulate luceneIndexManipulate = new LuceneIndexManipulate(clp.getIndexPath());
        luceneIndexManipulate.removeDocumentInIndex(field, termText);
        luceneIndexManipulate.closeIndex();
        LOGGER.info("Mail deleted: " + termText);
        ModifyParameter.splitDocumentId(termText);
        fsJournal.addEntry(journalEntry);
        String documentPath = readMailDocument.determineMailPath(document, clp);
        Path p = Paths.get(documentPath, new String[0]);
        Path actualDirectory = Paths.get(readMailDocument.getMailPath(), new String[0]);
        Path fileToDelete = Paths.get(readMailDocument.getMailPath() + readMailDocument.getFileToDelete(), new String[0]);
        System.out.println(readMailDocument.getMailPath() + readMailDocument.getFileToDelete());
        RemoveMailRepo.removeMailInRepo(fileToDelete);
        RemoveDirectoriesRepo.deleteDirectory(actualDirectory, (String)documentBoxAndId.get("box"));
    }

    public void removeDuplicateMailInIndex(ReadMailDocument readMailDocument, CommandLineParameters clp) throws IOException {
        LuceneIndexRead luceneIndexRead = new LuceneIndexRead(clp.getIndexPath());
        Integer maxDoc = luceneIndexRead.getLuceneIndexReader().maxDoc();
        for (int i = 0; i < maxDoc; ++i) {
            Document document = luceneIndexRead.getDocumentByDocID(i);
            if (document == null) continue;
            String documentPath = readMailDocument.determineMailPath(document, clp);
            Path p = Paths.get(documentPath, new String[0]);
            Path actualDirectory = Paths.get(readMailDocument.getMailPath(), new String[0]);
            if (Files.exists(p, new LinkOption[0])) continue;
            LOGGER.info("Duplicate mail deleted: " + document.get("id"));
            this.removeMailInIndex("id", document.get("id"), clp, new DeleteDuplicateIndexEntry(document.get("id")), readMailDocument);
        }
        luceneIndexRead.closeIndex();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean deleteDirectory(Path actualDirectory, String boxYear) {
        System.out.println(actualDirectory);
        if (actualDirectory.getFileName().toString().equals(boxYear)) return true;
        if (!Files.isDirectory(actualDirectory, new LinkOption[0])) return false;
        try (Stream<Path> entries = Files.list(actualDirectory);){
            if (!entries.findFirst().isPresent()) {
                Files.delete(actualDirectory);
                actualDirectory = actualDirectory.getParent();
                this.deleteDirectory(actualDirectory, boxYear);
                return true;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("Directory can not be deleted", e);
            return true;
        }
    }
}

