/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.repo;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.log4j.Logger;

public class RemoveDirectoriesRepo {
    private static final Logger LOGGER = Logger.getLogger(RemoveDirectoriesRepo.class);

    public static void deleteDirectory(Path actualDirectory, String boxYear) {
        if (!actualDirectory.getFileName().toString().equals(boxYear)) {
            if (Files.isDirectory(actualDirectory, new LinkOption[0])) {
                try (Stream<Path> entries = Files.list(actualDirectory);){
                    if (!entries.findFirst().isPresent()) {
                        Files.delete(actualDirectory);
                        LOGGER.info("Directory " + actualDirectory.toAbsolutePath().toString() + " was deleted");
                        actualDirectory = actualDirectory.getParent();
                        RemoveDirectoriesRepo.deleteDirectory(actualDirectory, boxYear);
                    } else {
                        LOGGER.info("Directory " + actualDirectory.toAbsolutePath().toString() + " is not empty. Deletion is finished");
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Directory " + actualDirectory.toAbsolutePath().toString() + " was not deleted", e);
                }
            } else {
                LOGGER.info("Directory " + actualDirectory.toAbsolutePath().toString() + " is not a directory. Deletion is finished");
            }
        }
    }
}

