/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.authentication;

import de.lwsystems.mailarchive.bennoauth.user.User;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BennoUserParameter {
    private static final Logger LOGGER = LogManager.getLogger(BennoUserParameter.class);
    private Set<String> containers;
    private Set<String> roles;
    private String displayName;
    private Set<String> mails;
    private String userId;
    private Set<String> filter;

    public BennoUserParameter() {
        this.containers = new HashSet<String>();
        this.roles = new HashSet<String>();
        this.displayName = "";
        this.mails = new HashSet<String>();
        this.userId = "";
        this.filter = new HashSet<String>();
    }

    public BennoUserParameter(User user) {
        this.containers = user.getContainer();
        this.mails = user.getEmail();
        this.filter = user.getFilter();
        this.displayName = user.getDisplayUsername();
        this.roles = user.getRoles();
        this.userId = user.getUsername();
    }

    public void setParameter(String key, String value) {
        switch (key) {
            case "ARCHIVE": {
                this.addContainer(value);
                break;
            }
            case "DISPLAYNAME": {
                if (!this.displayName.equals("")) break;
                this.setDisplayName(value);
                break;
            }
            case "FILTER": {
                this.addFilter(value);
                break;
            }
            case "MAIL": {
                this.addMail(value);
                break;
            }
            case "ROLE": {
                this.addRole(value);
                break;
            }
            case "USERID": {
                if (!this.userId.equals("")) break;
                this.setUserId(value);
                break;
            }
            default: {
                LOGGER.debug("Unexpected value: {}", (Object)key);
            }
        }
    }

    public Set<String> getContainers() {
        return this.containers;
    }

    private void addContainer(String container) {
        this.containers.add(container);
    }

    public void setContainers(Set<String> containers) {
        this.containers = containers;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    private void addRole(String role) {
        this.roles.add(role);
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Set<String> getMails() {
        return this.mails;
    }

    private void addMail(String mail) {
        this.mails.add(mail);
    }

    public void setMails(Set<String> mails) {
        this.mails = mails;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Set<String> getFilter() {
        return this.filter;
    }

    private void addFilter(String filter) {
        this.filter.add(filter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BennoUserParameter that = (BennoUserParameter)o;
        return Objects.equals(this.containers, that.containers) && Objects.equals(this.roles, that.roles) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.mails, that.mails) && Objects.equals(this.userId, that.userId) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.containers, this.roles, this.displayName, this.mails, this.userId, this.filter);
    }

    public String toString() {
        return "BennoUserParameter{containers=" + this.containers + ", roles=" + this.roles + ", displayName='" + this.displayName + "', mails=" + this.mails + ", userId='" + this.userId + "', filter=" + this.filter + "}";
    }
}

