/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.authentication;

import de.lwsystems.mailarchive.bennoauth.authentication.service.AuthenticationFactory;
import de.lwsystems.mailarchive.bennoauth.exception.AccessDataNotCorrectException;
import de.lwsystems.mailarchive.bennoauth.exception.AuthConnectionException;
import de.lwsystems.mailarchive.bennoauth.exception.AuthNotFoundException;
import de.lwsystems.mailarchive.bennoauth.user.User;
import de.lwsystems.mailarchive.bennoauth.user.UserRepository;
import java.io.IOException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CustomAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOGGER = LogManager.getLogger(CustomAuthenticationProvider.class);
    UserRepository userRepository;

    @Autowired
    public CustomAuthenticationProvider(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    private void addUserToBennoAuthDatabase(User bennoUserDetails) {
        if (this.userRepository.existsByUsername(bennoUserDetails.getUsername())) {
            LOGGER.info("Update user {} in auth database", (Object)bennoUserDetails.getUsername());
        } else {
            LOGGER.info("Add user {} to auth database", (Object)bennoUserDetails.getUsername());
        }
        this.userRepository.save(bennoUserDetails);
    }

    private Optional<User> loginToBennoAuthenticationService(String name, String password) throws AuthConnectionException, AuthNotFoundException, IOException {
        return AuthenticationFactory.getAuthenticationService().getUserFromAuthenticationService(name, password);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Optional<UsernamePasswordAuthenticationToken> authenticationResponse;
        Assert.notNull((Object)authentication, (String)"authentication cannot be null");
        String username = authentication.getName();
        String password = authentication.getCredentials().toString();
        try {
            Optional<User> optBennoUserDetails = this.loginToBennoAuthenticationService(username, password);
            if (!optBennoUserDetails.isPresent()) {
                throw new UsernameNotFoundException(username + " was not found or password was not correct");
            }
            User bennoUserDetails = optBennoUserDetails.get();
            this.registerUserToService(bennoUserDetails);
            LOGGER.info("User {} has logged in", (Object)bennoUserDetails.getUsername());
            authenticationResponse = Optional.of(new UsernamePasswordAuthenticationToken((Object)username, (Object)password, bennoUserDetails.getAuthorities()));
        }
        catch (AccessDataNotCorrectException ex) {
            throw new AccessDataNotCorrectException(username);
        }
        catch (AuthNotFoundException ex) {
            throw new AuthNotFoundException();
        }
        catch (AuthenticationServiceException ex) {
            throw new AuthenticationServiceException(ex.getMessage());
        }
        catch (AuthConnectionException ex) {
            throw new AuthConnectionException();
        }
        catch (IOException ex) {
            throw new AuthConnectionException(ex.getMessage(), ex);
        }
        return (Authentication)authenticationResponse.get();
    }

    private void registerUserToService(User bennoUserDetails) {
        this.addUserToBennoAuthDatabase(bennoUserDetails);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

