/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.authentication.service;

import de.lwsystems.mailarchive.bennoauth.authentication.service.AuthenticationService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationFactory {
    private List<AuthenticationService> authenticationServices;
    private static Map<String, AuthenticationService> authenticationServiceMap = new HashMap<String, AuthenticationService>();
    private static String authenticationServiceType;

    @Autowired
    public AuthenticationFactory(List<AuthenticationService> authenticationServices) {
        this.authenticationServices = authenticationServices;
    }

    @Value(value="${benno.extern.auth-type:userinfo_auth}")
    public void setAuthenticationServiceTypeName(String bennoAuthType) {
        authenticationServiceType = bennoAuthType;
    }

    @PostConstruct
    public void initAuthenticationServiceCache() {
        for (AuthenticationService service : this.authenticationServices) {
            authenticationServiceMap.put(service.getType(), service);
        }
    }

    public static AuthenticationService getAuthenticationService() {
        AuthenticationService service = authenticationServiceMap.get(AuthenticationFactory.getAuthenticationServiceType());
        if (service == null) {
            throw new IllegalStateException("Unknown authentication service type: " + AuthenticationFactory.getAuthenticationServiceType());
        }
        return service;
    }

    public static String getAuthenticationServiceType() {
        return authenticationServiceType;
    }
}

