/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.authentication.service.bennoauthd;

import de.lwsystems.mailarchive.bennoauth.authentication.service.AuthenticationService;
import de.lwsystems.mailarchive.bennoauth.authentication.service.bennoauthd.UserParameter;
import de.lwsystems.mailarchive.bennoauth.authentication.user.AuthenticationUserService;
import de.lwsystems.mailarchive.bennoauth.exception.AuthConnectionException;
import de.lwsystems.mailarchive.bennoauth.exception.AuthNotFoundException;
import de.lwsystems.mailarchive.bennoauth.user.User;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.security.AccessControlException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class BennoAuthDService
implements AuthenticationService {
    private static final Logger LOGGER = LogManager.getLogger(BennoAuthDService.class);
    @Value(value="${benno.extern.benno-authd.service:#{'/usr/sbin/benno_auth.d'}}")
    private String bennoAuthDPath;
    private boolean getUserWithoutPassword = false;
    PasswordEncoder passwordEncoder;
    AuthenticationUserService bennoAuthenticationUserService;
    private static final String METADATA_KEY = "REQUEST_TYPE";
    private static final String METADATA_VALUE = "metadata";

    @Autowired
    public BennoAuthDService(AuthenticationUserService authenticationUserService, PasswordEncoder passwordEncoder) {
        this.bennoAuthenticationUserService = authenticationUserService;
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    public String getType() {
        return "benno_authd";
    }

    @Override
    public Optional<User> getUserFromAuthenticationService(String username, String password) throws AuthConnectionException, AuthNotFoundException, IOException {
        return Optional.of(this.getUserFromBennoAuthService(username, password));
    }

    @Override
    public Optional<User> getUserFromAuthenticationService(String username) throws IOException {
        this.getUserWithoutPassword = true;
        return Optional.of(this.getUserFromBennoAuthService(username, "none"));
    }

    private User getUserFromBennoAuthService(String username, String password) throws AuthConnectionException, IOException {
        BufferedReader bennoAuthResponse = this.connectToBennoAuthService(username, password);
        User bennoUserDetails = this.bennoAuthenticationUserService.createUser(username, this.passwordEncoder.encode((CharSequence)password), UserParameter.readParameters(bennoAuthResponse, username));
        return bennoUserDetails;
    }

    private BufferedReader connectToBennoAuthService(String username, String password) throws IOException {
        File bennoAuthFile = new File(this.bennoAuthDPath);
        if (!bennoAuthFile.exists()) {
            throw new AuthNotFoundException();
        }
        String[] cmdline = new String[]{this.bennoAuthDPath, username, password};
        ProcessBuilder processBuilder = new ProcessBuilder(cmdline);
        this.getMetadataWithoutPasswordWhenActive(processBuilder);
        Process process = processBuilder.start();
        return this.sendCredentialsToAuthService(process, username, password);
    }

    private void getMetadataWithoutPasswordWhenActive(ProcessBuilder processBuilder) {
        if (this.getUserWithoutPassword) {
            LOGGER.debug("Set REQUEST_TYPE to metadata");
            processBuilder.environment().put(METADATA_KEY, METADATA_VALUE);
        }
    }

    private BufferedReader sendCredentialsToAuthService(Process process, String username, String password) throws IOException {
        BufferedReader bennoAuthResponse = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try (BufferedWriter bennoAuthStdinInput = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));){
            bennoAuthStdinInput.write(username);
            bennoAuthStdinInput.newLine();
            bennoAuthStdinInput.write(password);
            try {
                LOGGER.debug("Send login request for {} to benno_auth.d service {}", (Object)username, (Object)this.bennoAuthDPath);
                bennoAuthStdinInput.flush();
            }
            catch (AccessControlException ex) {
                throw new AccessControlException("The service benno_auth.d cannot be executed because of missing rights");
            }
            BufferedReader bufferedReader = bennoAuthResponse;
            return bufferedReader;
        }
    }
}

