/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.authentication.service.bennoauthd;

import de.lwsystems.mailarchive.bennoauth.authentication.BennoUserParameter;
import java.io.BufferedReader;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserParameter {
    private static final Logger LOGGER = LogManager.getLogger(UserParameter.class);
    private static final String ERROR = "ERROR";
    private static final String REMOVE_PATTERN = " .*";

    private UserParameter() {
    }

    public static BennoUserParameter readParameters(BufferedReader bennoUserParameters, String username) throws IOException {
        boolean paramsExists = false;
        String bennoAuthResponseKey = "";
        BennoUserParameter bennoUserParameter = new BennoUserParameter();
        try {
            String bennoAuthResponseLine;
            LOGGER.debug("Start to determine values from benno_auth.d service for user {}", (Object)username);
            while ((bennoAuthResponseLine = bennoUserParameters.readLine()) != null) {
                paramsExists = true;
                if (bennoAuthResponseLine.contains(ERROR)) {
                    throw new UsernameNotFoundException("Cannot find user " + username + " in benno_auth.d service");
                }
                bennoAuthResponseKey = bennoAuthResponseLine.replaceAll(REMOVE_PATTERN, "");
                LOGGER.debug("Line : {} ", (Object)bennoAuthResponseLine);
                Map<String, String> bennoAuthResponse = UserParameter.splitBennoAuthResponseLine(bennoAuthResponseLine, bennoAuthResponseKey);
                bennoUserParameter.setParameter(bennoAuthResponseKey, bennoAuthResponse.get(bennoAuthResponseKey));
            }
        }
        catch (NullPointerException ex) {
            LOGGER.error("The BufferedReader for determining the user parameters is empty.", (Throwable)ex);
            return null;
        }
        if (!paramsExists) {
            throw new AccessControlException("The service benno_auth.d cannot be executed because of missing rights");
        }
        return bennoUserParameter;
    }

    private static Map<String, String> splitBennoAuthResponseLine(String bennoAuthResponseLine, String bennoAuthKey) {
        int bennoParameterKeyStartIndex = bennoAuthResponseLine.indexOf(bennoAuthKey);
        int bennoParameterValueStartIndex = bennoParameterKeyStartIndex + bennoAuthKey.length();
        HashMap<String, String> splitBennoAuthResponseLine = new HashMap<String, String>();
        String parameterKey = bennoAuthResponseLine.substring(bennoParameterKeyStartIndex, bennoParameterValueStartIndex);
        String parameterValue = bennoAuthResponseLine.substring(bennoParameterValueStartIndex + 1);
        LOGGER.debug("Key : {} , Value : {}", (Object)parameterKey, (Object)parameterValue);
        splitBennoAuthResponseLine.put(parameterKey, parameterValue);
        return splitBennoAuthResponseLine;
    }
}

