/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.authentication.service.userinfoauth;

import de.lwsystems.mailarchive.bennoauth.authentication.BennoUserParameter;
import de.lwsystems.mailarchive.bennoauth.authentication.ThirdPartyAuthenticationService;
import de.lwsystems.mailarchive.bennoauth.authentication.service.userinfoauth.Data;
import de.lwsystems.mailarchive.bennoauth.authentication.service.userinfoauth.UserinfoAuthCall;
import de.lwsystems.mailarchive.bennoauth.authentication.service.userinfoauth.UserinfoAuthStatus;
import de.lwsystems.mailarchive.bennoauth.authentication.service.userinfoauth.UserinfoAuthType;
import de.lwsystems.mailarchive.bennoauth.authentication.service.userinfoauth.UserinfoAuthUser;
import de.lwsystems.mailarchive.bennoauth.authentication.user.AuthenticationUserService;
import de.lwsystems.mailarchive.bennoauth.exception.RestAuthenticationError;
import de.lwsystems.mailarchive.bennoauth.user.User;
import java.util.Map;
import java.util.Optional;
import kong.unirest.HttpResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class UserinfoAuth
implements ThirdPartyAuthenticationService {
    private static final Logger LOGGER = LogManager.getLogger(UserinfoAuth.class);
    private static final String USERINFO_AUTH_EXCEPTION_TEXT = "Userinfo-Auth exception: ";
    private static final String USERNAME_NOT_NULL_TEXT = "username cannot be null";
    private static final String EMPTY_STRING = "";
    AuthenticationUserService bennoAuthenticationUserService;
    PasswordEncoder passwordEncoder;
    @Value(value="${benno.extern.userinfo-auth.url:#{null}}")
    private String restHost;
    @Value(value="${benno.extern.userinfo-auth.token:#{null}}")
    private String restToken;

    @Override
    public String getType() {
        return "userinfo_auth";
    }

    public String getRestHost() {
        return this.restHost;
    }

    public String getRestToken() {
        return this.restToken;
    }

    @Autowired
    public UserinfoAuth(PasswordEncoder passwordEncoder, AuthenticationUserService bennoAuthenticationUserService) {
        this.passwordEncoder = passwordEncoder;
        this.bennoAuthenticationUserService = bennoAuthenticationUserService;
    }

    @Override
    public Optional<User> getUserFromAuthenticationService(String username, String password) {
        Assert.notNull((Object)username, (String)USERNAME_NOT_NULL_TEXT);
        Assert.notNull((Object)password, (String)"password cannot be null");
        HttpResponse<UserinfoAuthUser> result = this.callRest(username, password);
        if (result.isSuccess() && ((UserinfoAuthUser)result.getBody()).getStatus().equalsIgnoreCase(UserinfoAuthStatus.SUCCESS.toString())) {
            return this.createUserIfExists(result, username, UserinfoAuthType.AUTHENTICATE);
        }
        if (!result.isSuccess()) {
            throw new RestAuthenticationError(USERINFO_AUTH_EXCEPTION_TEXT + result.getStatus() + " " + result.getStatusText());
        }
        throw new RestAuthenticationError(USERINFO_AUTH_EXCEPTION_TEXT + ((UserinfoAuthUser)result.getBody()).getUserinfo().getInfo());
    }

    @Override
    public Optional<User> getUserFromAuthenticationService(String username, Map<String, Object> additionalUserInfos) {
        Assert.notNull((Object)username, (String)USERNAME_NOT_NULL_TEXT);
        Assert.notNull(additionalUserInfos, (String)"additionalUserInfos cannot be null");
        HttpResponse<UserinfoAuthUser> result = this.callRest(username, additionalUserInfos);
        if (result.isSuccess()) {
            return this.createUserIfExists(result, username, UserinfoAuthType.METADATA);
        }
        throw new RestAuthenticationError(USERINFO_AUTH_EXCEPTION_TEXT + result.getStatus() + " " + result.getStatusText());
    }

    @Override
    public Optional<User> getUserFromAuthenticationService(String username) {
        Assert.notNull((Object)username, (String)USERNAME_NOT_NULL_TEXT);
        HttpResponse<UserinfoAuthUser> result = this.callRest(username);
        if (result.isSuccess()) {
            return this.createUserIfExists(result, username, UserinfoAuthType.METADATA);
        }
        LOGGER.error("{} {} {}", (Object)USERINFO_AUTH_EXCEPTION_TEXT, (Object)result.getStatus(), (Object)result.getStatusText());
        return Optional.empty();
    }

    private Optional<User> createUserIfExists(HttpResponse<UserinfoAuthUser> result, String username, UserinfoAuthType restType) {
        Assert.notNull((Object)username, (String)USERNAME_NOT_NULL_TEXT);
        Assert.notNull(result, (String)"result cannot be null");
        Assert.notNull((Object)((Object)restType), (String)"restType cannot be null");
        Data user = ((UserinfoAuthUser)result.getBody()).getUserinfo();
        if (((UserinfoAuthUser)result.getBody()).getStatus().equalsIgnoreCase(UserinfoAuthStatus.FAIL.toString())) {
            StringBuilder errorMessage = new StringBuilder();
            if (UserinfoAuthType.AUTHENTICATE == restType) {
                errorMessage.append("Userinfo-Auth exception:  Login to auth rest is not possible as user " + username + ". ").append("\n");
            } else if (UserinfoAuthType.METADATA == restType) {
                errorMessage.append("Userinfo-Auth exception: No metadata could be found for user " + username).append("\n");
            }
            errorMessage.append(user.getInfo());
            throw new AuthenticationServiceException(errorMessage.toString());
        }
        if (((UserinfoAuthUser)result.getBody()).getStatus().equalsIgnoreCase(UserinfoAuthStatus.ERROR.toString())) {
            throw new AuthenticationServiceException(((UserinfoAuthUser)result.getBody()).getUserinfo().getInfo());
        }
        if (UserinfoAuthType.AUTHENTICATE == restType) {
            LOGGER.info("Userinfo-Auth login for user {} was successful", (Object)username);
        } else {
            LOGGER.info("{} exists in Userinfo-Auth", (Object)username);
        }
        return Optional.of(this.bennoAuthenticationUserService.createUser(username, this.passwordEncoder.encode((CharSequence)EMPTY_STRING), this.setBennoUserParameter(user, username)));
    }

    private void checkRestParameters() {
        if (this.getRestHost() == null) {
            throw new AuthenticationServiceException("benno.extern.userinfo-auth.url is not set");
        }
        if (this.getRestToken() == null) {
            throw new AuthenticationServiceException("benno.extern.userinfo-auth.token is not set");
        }
    }

    private HttpResponse<UserinfoAuthUser> callRest(String username) {
        Assert.notNull((Object)username, (String)USERNAME_NOT_NULL_TEXT);
        this.checkRestParameters();
        UserinfoAuthCall restCall = new UserinfoAuthCall.UserinfoAuthCallBuilder(this.restHost, username, this.restToken, UserinfoAuthType.METADATA).build();
        return restCall.callUrl();
    }

    private HttpResponse<UserinfoAuthUser> callRest(String username, String password) {
        Assert.notNull((Object)username, (String)USERNAME_NOT_NULL_TEXT);
        Assert.notNull((Object)password, (String)"password cannot be null");
        this.checkRestParameters();
        UserinfoAuthCall restCall = new UserinfoAuthCall.UserinfoAuthCallBuilder(this.restHost, username, this.restToken, UserinfoAuthType.AUTHENTICATE).setPassword(password).build();
        return restCall.callUrl();
    }

    private HttpResponse<UserinfoAuthUser> callRest(String username, Map<String, Object> additionalUserInfos) {
        Assert.notNull((Object)username, (String)USERNAME_NOT_NULL_TEXT);
        Assert.notNull(additionalUserInfos, (String)"additionalUserInfos cannot be null");
        this.checkRestParameters();
        UserinfoAuthCall restCall = new UserinfoAuthCall.UserinfoAuthCallBuilder(this.restHost, username, this.restToken, UserinfoAuthType.METADATA).setAdditionalUserInfos(additionalUserInfos).build();
        return restCall.callUrl();
    }

    private BennoUserParameter setBennoUserParameter(Data userInfo, String username) {
        Assert.notNull((Object)userInfo, (String)"userInfo cannot be null");
        Assert.notNull((Object)username, (String)USERNAME_NOT_NULL_TEXT);
        BennoUserParameter bennoUserParameter = new BennoUserParameter();
        try {
            LOGGER.debug("Data object from Userinfo-Auth : {}", (Object)userInfo);
            bennoUserParameter.setContainers(userInfo.getArchives());
            bennoUserParameter.setMails(userInfo.getMails());
            bennoUserParameter.setRoles(userInfo.getRoles());
            bennoUserParameter.setDisplayName(userInfo.getDisplayname());
            bennoUserParameter.setUserId(username);
        }
        catch (NullPointerException ex) {
            throw new RestAuthenticationError("Userinfo object is not complete", ex);
        }
        return bennoUserParameter;
    }
}

