/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.authentication.service.userinfoauth;

import de.lwsystems.mailarchive.bennoauth.authentication.service.userinfoauth.UserinfoAuthParameters;
import de.lwsystems.mailarchive.bennoauth.authentication.service.userinfoauth.UserinfoAuthRequestParameter;
import de.lwsystems.mailarchive.bennoauth.authentication.service.userinfoauth.UserinfoAuthType;
import de.lwsystems.mailarchive.bennoauth.authentication.service.userinfoauth.UserinfoAuthUser;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.springframework.util.Assert;

public class UserinfoAuthCall {
    private static final Logger LOGGER = LogManager.getLogger(UserinfoAuthCall.class);
    private String restHost;
    private String username;
    private String restToken;
    private UserinfoAuthType userinfoAuthType;
    private String password = "";
    Map<String, Object> addUserInfos;
    private String url;
    private UserinfoAuthParameters userinfoAuthParameters;

    private void setUrl() {
        this.url = this.restHost;
        this.userinfoAuthParameters = new UserinfoAuthParameters(this.username, this.password, this.restToken, this.userinfoAuthType.toString().toLowerCase(Locale.ROOT), this.addUserInfos);
    }

    private JSONObject buildRestBody() {
        String oidcToken = "";
        JSONObject restBody = new JSONObject().put(UserinfoAuthRequestParameter.USER.getName(), (Object)this.userinfoAuthParameters.getUsername()).put(UserinfoAuthRequestParameter.PASSWORD.getName(), (Object)this.userinfoAuthParameters.getPassword()).put(UserinfoAuthRequestParameter.TYPE.getName(), (Object)this.userinfoAuthParameters.getType());
        if (!this.userinfoAuthParameters.getUserValues().isEmpty()) {
            try {
                if (this.userinfoAuthParameters.getUserValues().containsKey(UserinfoAuthRequestParameter.EXTERNAL_OIDC_TOKEN.getName())) {
                    oidcToken = this.userinfoAuthParameters.getUserValues().get(UserinfoAuthRequestParameter.EXTERNAL_OIDC_TOKEN.getName()).toString();
                    restBody.put(UserinfoAuthRequestParameter.EXTERNAL_OIDC_TOKEN.getName(), (Object)oidcToken);
                }
            }
            catch (NullPointerException ex) {
                LOGGER.warn("{} is not available for Userinfo-Auth", (Object)UserinfoAuthRequestParameter.EXTERNAL_OIDC_TOKEN.getName());
            }
            try {
                if (this.userinfoAuthParameters.getUserValues().containsKey(UserinfoAuthRequestParameter.ADDITIONAL_USER_INFOS.getName()) && this.userinfoAuthParameters.getUserValues().get(UserinfoAuthRequestParameter.ADDITIONAL_USER_INFOS.getName()) instanceof Map && ((Map)this.userinfoAuthParameters.getUserValues().get(UserinfoAuthRequestParameter.ADDITIONAL_USER_INFOS.getName())).size() > 0) {
                    LinkedHashMap linkedHashMap = (LinkedHashMap)this.userinfoAuthParameters.getUserValues().get(UserinfoAuthRequestParameter.ADDITIONAL_USER_INFOS.getName());
                    linkedHashMap.values().removeAll(Collections.singleton(null));
                    restBody.put(UserinfoAuthRequestParameter.ADDITIONAL_USER_INFOS.getName(), (Map)linkedHashMap);
                }
            }
            catch (NullPointerException ex) {
                LOGGER.warn("{} is not available for Userinfo-Auth", (Object)UserinfoAuthRequestParameter.ADDITIONAL_USER_INFOS.getName());
            }
        }
        return restBody;
    }

    public HttpResponse<UserinfoAuthUser> callUrl() {
        JSONObject restBody = this.buildRestBody();
        LOGGER.debug("Userinfo-Auth call");
        LOGGER.debug("Address: {} ", (Object)this.url);
        LOGGER.debug("Username: {}", (Object)this.userinfoAuthParameters.getUsername());
        LOGGER.debug("Type: {}", (Object)this.userinfoAuthParameters.getType());
        return ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)this.url).header("Authorization", "Bearer " + this.userinfoAuthParameters.getRestToken())).header("content-type", "application/json")).body(restBody.toString()).asObject(UserinfoAuthUser.class);
    }

    public String getUrl() {
        return this.url;
    }

    private UserinfoAuthCall(UserinfoAuthCallBuilder builder) {
        this.restHost = builder.restHost;
        this.restToken = builder.restToken;
        this.username = builder.username;
        this.password = builder.password;
        this.addUserInfos = builder.addUserInfos;
        this.userinfoAuthType = builder.userinfoAuthType;
        this.setUrl();
    }

    public static class UserinfoAuthCallBuilder {
        private String restHost;
        private String username;
        private String restToken;
        private UserinfoAuthType userinfoAuthType;
        private String password = "";
        Map<String, Object> addUserInfos = new HashMap<String, Object>();

        public UserinfoAuthCallBuilder(String restHost, String username, String restToken, UserinfoAuthType userinfoAuthType) {
            Assert.notNull((Object)restHost, (String)"restHost cannot be null");
            Assert.notNull((Object)restToken, (String)"restToken cannot be null");
            Assert.notNull((Object)username, (String)"username cannot be null");
            Assert.notNull((Object)((Object)userinfoAuthType), (String)"userinfoAuthType cannot be null");
            this.restHost = restHost;
            this.username = username;
            this.restToken = restToken;
            this.userinfoAuthType = userinfoAuthType;
        }

        public UserinfoAuthCallBuilder setPassword(String password) {
            this.password = String.format(password, new Object[0]);
            return this;
        }

        public UserinfoAuthCallBuilder setAdditionalUserInfos(Map<String, Object> addUserInfos) {
            this.addUserInfos = addUserInfos;
            return this;
        }

        public UserinfoAuthCall build() {
            return new UserinfoAuthCall(this);
        }
    }
}

