/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.authentication.user;

import de.lwsystems.mailarchive.bennoauth.authentication.BennoUserParameter;
import de.lwsystems.mailarchive.bennoauth.authentication.user.AuthenticationUser;
import de.lwsystems.mailarchive.bennoauth.user.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AuthenticationUserService
implements AuthenticationUser {
    private static final Logger LOGGER = LogManager.getLogger(AuthenticationUserService.class);

    @Override
    public User createUser(String username, String password, BennoUserParameter bennoUserParameter) {
        Assert.notNull((Object)username, (String)"username cannot be null");
        Assert.notNull((Object)password, (String)"password cannot be null");
        Assert.notNull((Object)bennoUserParameter, (String)"bennoUserParameter cannot be null");
        if (username.isEmpty()) {
            throw new IllegalArgumentException("Cannot create user because username is not set");
        }
        if (password.isEmpty()) {
            throw new IllegalArgumentException("Cannot create user because password is not set");
        }
        List<GrantedAuthority> authorities = this.getAuthoritiesForUser(bennoUserParameter);
        LOGGER.debug("User object is created for authentication service");
        return new User(username, password, bennoUserParameter, authorities);
    }

    private List<GrantedAuthority> getAuthoritiesForUser(BennoUserParameter bennoUserParameter) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        Set<String> roles = bennoUserParameter.getRoles();
        if (roles.isEmpty()) {
            LOGGER.debug("No roles for user was found. Set standard role ROLE_USER to {}", (Object)bennoUserParameter.getUserId());
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_USER"));
        }
        roles.forEach(role -> authorities.add((GrantedAuthority)new SimpleGrantedAuthority(role)));
        return authorities;
    }
}

