/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="benno")
public class BennoClients {
    private List<Client> clients = new ArrayList<Client>();

    public List<Client> getClients() {
        return this.clients;
    }

    public void setClients(List<Client> clients) {
        this.clients = clients;
    }

    public static class Client {
        private String clientId;
        private String clientSecret;
        private String[] scopes;
        private String[] grantTypes;
        private String[] redirectUris;
        private int jwtAccessTokenDuration;
        private int jwtRefreshTokenDuration;

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public String[] getScopes() {
            return this.scopes;
        }

        public void setScopes(String[] scopes) {
            this.scopes = scopes;
        }

        public String[] getGrantTypes() {
            return this.grantTypes;
        }

        public void setGrantTypes(String[] grantTypes) {
            this.grantTypes = grantTypes;
        }

        public int getJwtAccessTokenDuration() {
            return this.jwtAccessTokenDuration;
        }

        public void setJwtAccessTokenDuration(int jwtAccessTokenDuration) {
            this.jwtAccessTokenDuration = jwtAccessTokenDuration;
        }

        public int getJwtRefreshTokenDuration() {
            return this.jwtRefreshTokenDuration;
        }

        public void setJwtRefreshTokenDuration(int jwtRefreshTokenDuration) {
            this.jwtRefreshTokenDuration = jwtRefreshTokenDuration;
        }

        public Set<String> getRedirectUrisAsSet() {
            return new HashSet<String>(Arrays.asList(this.redirectUris));
        }

        public void setRedirectUris(String[] redirectUris) {
            this.redirectUris = redirectUris;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Client client = (Client)o;
            return this.jwtAccessTokenDuration == client.jwtAccessTokenDuration && this.jwtRefreshTokenDuration == client.jwtRefreshTokenDuration && Objects.equals(this.clientId, client.clientId) && Objects.equals(this.clientSecret, client.clientSecret) && Arrays.equals(this.scopes, client.scopes) && Arrays.equals(this.grantTypes, client.grantTypes) && Arrays.equals(this.redirectUris, client.redirectUris);
        }

        public int hashCode() {
            int result = Objects.hash(this.clientId, this.clientSecret, this.jwtAccessTokenDuration, this.jwtRefreshTokenDuration);
            result = 31 * result + Arrays.hashCode(this.scopes);
            result = 31 * result + Arrays.hashCode(this.grantTypes);
            result = 31 * result + Arrays.hashCode(this.redirectUris);
            return result;
        }

        public String toString() {
            return "Client{clientId='" + this.clientId + "', scopes=" + Arrays.toString(this.scopes) + ", grantTypes=" + Arrays.toString(this.grantTypes) + ", redirectUris=" + Arrays.toString(this.redirectUris) + ", jwtAccessTokenDuration=" + this.jwtAccessTokenDuration + ", jwtRefreshTokenDuration=" + this.jwtRefreshTokenDuration + "}";
        }
    }
}

