/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.client;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.lwsystems.mailarchive.bennoauth.client.utils.ClientDeserializer;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.util.Assert;

@JsonDeserialize(using=ClientDeserializer.class)
public class Client {
    private String id;
    private String clientId;
    private String clientSecret;
    private String[] scopes;
    private String[] grantTypes;
    private boolean pkce;
    @NotNull
    private Set<String> redirectUris;
    private Duration jwtAccessTokenDuration;
    private Duration jwtRefreshTokenDuration;
    private boolean reuseRefreshTokens;

    private Client(ClientBuilder clientBuilder) {
        this.id = clientBuilder.id;
        this.clientId = clientBuilder.clientId;
        this.clientSecret = clientBuilder.clientSecret;
        this.scopes = clientBuilder.scopes;
        this.grantTypes = clientBuilder.grantTypes;
        this.pkce = clientBuilder.pkce;
        this.redirectUris = clientBuilder.redirectUris;
        this.jwtAccessTokenDuration = clientBuilder.jwtAccessTokenDuration;
        this.jwtRefreshTokenDuration = clientBuilder.jwtRefreshTokenDuration;
        this.reuseRefreshTokens = clientBuilder.reuseRefreshTokens;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public String[] getGrantTypes() {
        return this.grantTypes;
    }

    public Set<String> getRedirectUris() {
        return this.redirectUris;
    }

    public Duration getJwtAccessTokenDuration() {
        return this.jwtAccessTokenDuration;
    }

    public Duration getJwtRefreshTokenDuration() {
        return this.jwtRefreshTokenDuration;
    }

    public boolean reuseRefreshToken() {
        return this.reuseRefreshTokens;
    }

    public void setIdToExistingClient(String id) {
        this.id = id;
    }

    public RegisteredClient getRegisteredClient() {
        Set<String> clientScopes = Set.of(this.scopes);
        Set<AuthorizationGrantType> clientGrantTypes = this.createAuthorizationGrantTypeSet();
        TokenSettings tokenSettings = this.createTokenSettings();
        return this.buildClient(clientScopes, clientGrantTypes, tokenSettings);
    }

    private RegisteredClient buildClient(Set<String> clientScopes, Set<AuthorizationGrantType> clientGrantTypes, TokenSettings tokenSettings) {
        RegisteredClient.Builder registeredClient = RegisteredClient.withId((String)this.id).clientId(this.clientId).authorizationGrantTypes(authorizationGrantTypes -> authorizationGrantTypes.addAll(clientGrantTypes)).redirectUris(uris -> uris.addAll(this.redirectUris)).scopes(registeredClientScope -> registeredClientScope.addAll(clientScopes)).tokenSettings(tokenSettings);
        if (!this.pkce) {
            return registeredClient.clientSecret(this.clientSecret).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).clientSettings(ClientSettings.builder().requireAuthorizationConsent(true).build()).build();
        }
        return registeredClient.clientAuthenticationMethod(ClientAuthenticationMethod.NONE).clientSettings(ClientSettings.builder().requireAuthorizationConsent(true).requireProofKey(true).build()).build();
    }

    private TokenSettings createTokenSettings() {
        return TokenSettings.builder().accessTokenTimeToLive(this.jwtAccessTokenDuration).refreshTokenTimeToLive(this.jwtRefreshTokenDuration).reuseRefreshTokens(this.reuseRefreshTokens).build();
    }

    private Set<AuthorizationGrantType> createAuthorizationGrantTypeSet() {
        HashSet<AuthorizationGrantType> clientGrantTypes = new HashSet<AuthorizationGrantType>();
        for (String grantType : this.grantTypes) {
            clientGrantTypes.add(new AuthorizationGrantType(grantType));
        }
        return clientGrantTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client client = (Client)o;
        return this.pkce == client.pkce && this.id.equals(client.id) && this.clientId.equals(client.clientId) && Objects.equals(this.clientSecret, client.clientSecret) && Arrays.equals(this.scopes, client.scopes) && Arrays.equals(this.grantTypes, client.grantTypes) && this.redirectUris.equals(client.redirectUris) && this.jwtAccessTokenDuration.equals(client.jwtAccessTokenDuration) && this.jwtRefreshTokenDuration.equals(client.jwtRefreshTokenDuration);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.clientId, this.clientSecret, this.pkce, this.redirectUris, this.jwtAccessTokenDuration, this.jwtRefreshTokenDuration);
        result = 31 * result + Arrays.hashCode(this.scopes);
        result = 31 * result + Arrays.hashCode(this.grantTypes);
        return result;
    }

    public String toString() {
        return "Client{id='" + this.id + "', clientId='" + this.clientId + "', scopes=" + Arrays.toString(this.scopes) + ", grantTypes=" + Arrays.toString(this.grantTypes) + ", pkce=" + this.pkce + ", redirectUris=" + this.redirectUris + ", jwtAccessTokenDuration=" + this.jwtAccessTokenDuration.toSeconds() + ", jwtRefreshTokenDuration=" + this.jwtRefreshTokenDuration.toSeconds() + "}";
    }

    public static class ClientBuilder {
        private String id = UUID.randomUUID().toString();
        private String clientId;
        private String clientSecret;
        private String[] scopes;
        private String[] grantTypes;
        private boolean pkce;
        @NotNull
        private Set<String> redirectUris;
        private Duration jwtAccessTokenDuration = Duration.ofSeconds(1800L);
        private Duration jwtRefreshTokenDuration = Duration.ofSeconds(2592000L);
        private boolean reuseRefreshTokens = false;

        public ClientBuilder(String clientId, String[] scopes, String[] grantTypes, Set<String> redirectUris) {
            Assert.notNull((Object)clientId, (String)"clientId cannot be null");
            Assert.notNull((Object)scopes, (String)"scopes cannot be null");
            Assert.notNull((Object)grantTypes, (String)"userinfoAuthType cannot be null");
            Assert.notNull(redirectUris, (String)"redirectUris cannot be null");
            this.clientId = clientId;
            this.scopes = scopes;
            this.grantTypes = grantTypes;
            this.redirectUris = redirectUris;
        }

        public Client buildPkceClient() {
            this.pkce = true;
            this.clientSecret = "";
            return new Client(this);
        }

        public Client buildClientWithSecret(String clientSecret) {
            Assert.notNull((Object)clientSecret, (String)"clientSecret cannot be null");
            this.pkce = false;
            this.clientSecret = clientSecret;
            return new Client(this);
        }

        public ClientBuilder setJwtAccessTokenDuration(Duration jwtAccessTokenDuration) {
            if (jwtAccessTokenDuration.toSeconds() > 0L) {
                this.jwtAccessTokenDuration = jwtAccessTokenDuration;
            }
            return this;
        }

        public ClientBuilder setJwtRefreshTokenDuration(Duration jwtRefreshTokenDuration) {
            if (jwtRefreshTokenDuration.toSeconds() > 0L) {
                this.jwtRefreshTokenDuration = jwtRefreshTokenDuration;
            }
            return this;
        }

        public ClientBuilder reuseRefreshToken(boolean reuseRefreshToken) {
            this.reuseRefreshTokens = reuseRefreshToken;
            return this;
        }
    }
}

