/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.client.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.lwsystems.mailarchive.bennoauth.client.Client;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientDeserializer
extends StdDeserializer<Client> {
    private static final Logger LOGGER = LogManager.getLogger(ClientDeserializer.class);
    private static final String SPLIT_REGEX = "\\s*,\\s*";
    private static final String CLIENT_SECRET = "clientSecret";
    private static final String JWT_ACCESS_TOKEN_DURATION = "jwtAccessTokenDuration";
    private static final String JWT_REFRESH_TOKEN_DURATION = "jwtRefreshTokenDuration";
    private static final String PKCE = "pkce";

    public ClientDeserializer() {
        this(null);
    }

    public ClientDeserializer(Class<?> vc) {
        super(vc);
    }

    public Client deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode clientNode = (JsonNode)jp.getCodec().readTree(jp);
        return this.convertNodeToClient(clientNode);
    }

    private Client convertNodeToClient(JsonNode clientNode) {
        int jwtAccessTokenSeconds = 0;
        int jwtRefreshTokenSeconds = 0;
        String clientSecret = null;
        boolean pkce = false;
        if (clientNode.get(JWT_ACCESS_TOKEN_DURATION) != null) {
            jwtAccessTokenSeconds = clientNode.get(JWT_ACCESS_TOKEN_DURATION).intValue();
        }
        if (clientNode.get(JWT_REFRESH_TOKEN_DURATION) != null) {
            jwtRefreshTokenSeconds = clientNode.get(JWT_REFRESH_TOKEN_DURATION).intValue();
        }
        if (clientNode.get(PKCE) != null) {
            pkce = clientNode.get(PKCE).asBoolean();
            clientSecret = clientNode.get(CLIENT_SECRET) != null ? clientNode.get(CLIENT_SECRET).asText().stripLeading() : "";
        }
        if (clientNode.get(CLIENT_SECRET) != null) {
            clientSecret = clientNode.get(CLIENT_SECRET).asText().stripLeading();
        }
        try {
            Client.ClientBuilder clientBuilder = new Client.ClientBuilder(clientNode.get("clientId").asText().stripLeading(), clientNode.get("scopes").asText().stripLeading().split(SPLIT_REGEX), clientNode.get("grantTypes").asText().stripLeading().split(SPLIT_REGEX), new HashSet<String>(Arrays.asList(clientNode.get("redirectUris").asText().stripLeading().split(SPLIT_REGEX)))).setJwtAccessTokenDuration(Duration.ofSeconds(jwtAccessTokenSeconds)).setJwtRefreshTokenDuration(Duration.ofSeconds(jwtRefreshTokenSeconds));
            if (pkce) {
                Client pkceClient = clientBuilder.buildPkceClient();
                LOGGER.debug("Registered client in benno: {}", (Object)pkceClient);
                return pkceClient;
            }
            Client secretClient = clientBuilder.buildClientWithSecret(clientSecret);
            LOGGER.debug("Registered client in benno: {}", (Object)secretClient);
            return secretClient;
        }
        catch (NullPointerException ex) {
            LOGGER.error("Can't deserialize client from yml file", (Throwable)ex);
            return null;
        }
    }
}

