/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.client.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.lwsystems.mailarchive.bennoauth.client.Client;
import de.lwsystems.mailarchive.bennoauth.common.utils.YmlReader;
import de.lwsystems.mailarchive.bennoauth.exception.ClientNotFoundException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ClientYmlReader
implements YmlReader {
    @Value(value="${benno.clients.path}")
    private String clientYaml;
    private static final String SUFFIX_PATTERN = "yml";
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public ClientYmlReader() {
        this.mapper.findAndRegisterModules();
        this.mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        this.mapper.enable(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES);
        this.mapper.enable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES);
        this.mapper.disable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, Object> readYmlFile() throws IOException {
        HashMap<String, Object> bennoClients = new HashMap<String, Object>();
        Path clientYmlDirPath = Paths.get(this.clientYaml, new String[0]);
        if (!Files.exists(clientYmlDirPath, new LinkOption[0])) throw new ClientNotFoundException("Client Directory " + this.clientYaml + " was not found");
        List<Path> paths = this.getYmlFilesFromClientDir(clientYmlDirPath);
        if (paths.isEmpty()) throw new ClientNotFoundException("No yml files found in client Directory " + this.clientYaml);
        for (Path file : paths) {
            Client client = this.getClientFromYmlFile(file.toFile());
            if (client == null || bennoClients.containsKey(client.getClientId())) continue;
            bennoClients.put(client.getClientId().toLowerCase(), client);
        }
        return bennoClients;
    }

    private List<Path> getYmlFilesFromClientDir(Path path) throws IOException {
        List<Path> result;
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            result = walk.filter(file -> file.toString().endsWith(SUFFIX_PATTERN)).collect(Collectors.toList());
        }
        return result;
    }

    private Client getClientFromYmlFile(File ymlFile) throws IOException {
        return (Client)this.mapper.readValue(ymlFile, Client.class);
    }
}

