/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.common.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import de.lwsystems.mailarchive.bennoauth.authentication.CustomOAuth2AuthorizationCodeAuthenticationProvider;
import de.lwsystems.mailarchive.bennoauth.authentication.CustomOAuth2RefreshTokenAuthenticationProvider;
import de.lwsystems.mailarchive.bennoauth.client.Client;
import de.lwsystems.mailarchive.bennoauth.client.utils.ClientYmlReader;
import de.lwsystems.mailarchive.bennoauth.common.config.CustomOAuth2ConfigurerUtils;
import de.lwsystems.mailarchive.bennoauth.common.mixin.JsonArrayMixin;
import de.lwsystems.mailarchive.bennoauth.common.mixin.LongMixin;
import de.lwsystems.mailarchive.bennoauth.common.utils.KeyGeneratorUtils;
import de.lwsystems.mailarchive.bennoauth.exception.MissingParameterException;
import de.lwsystems.mailarchive.bennoauth.fid.FederatedIdentityConfigurer;
import de.lwsystems.mailarchive.bennoauth.userinfo.Userinfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.jackson2.SecurityJackson2Modules;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.authorization.JdbcOAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.JdbcOAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientCredentialsAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.client.JdbcRegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configuration.OAuth2AuthorizationServerConfiguration;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.jackson2.OAuth2AuthorizationServerJackson2Module;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
public class AuthorizationServerConfig {
    private static final Logger LOGGER = LogManager.getLogger(AuthorizationServerConfig.class);
    @Value(value="${benno.provider.issuer}")
    private String bennoProviderIssuer;
    private Userinfo userinfo;
    @Value(value="${benno.cors.cross-origin-urls:#{null}}")
    private String[] crossOriginUrls;
    private static CustomOAuth2AuthorizationCodeAuthenticationProvider authorizationCodeAuthenticationProvider;
    private static CustomOAuth2RefreshTokenAuthenticationProvider refreshTokenAuthenticationProvider;
    private static final String CUSTOM_CONSENT_PAGE_URI = "/oauth2/consent";

    @Autowired
    public AuthorizationServerConfig(Userinfo userinfo) {
        this.userinfo = userinfo;
    }

    private static Consumer<List<AuthenticationProvider>> createDefaultAuthenticationProviders(HttpSecurity httpSecurity) {
        ArrayList<Object> authenticationProviders = new ArrayList<Object>();
        OAuth2AuthorizationService authorizationService = CustomOAuth2ConfigurerUtils.getAuthorizationService(httpSecurity);
        OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator = CustomOAuth2ConfigurerUtils.getTokenGenerator(httpSecurity);
        authorizationCodeAuthenticationProvider = new CustomOAuth2AuthorizationCodeAuthenticationProvider(authorizationService, tokenGenerator);
        authenticationProviders.add(authorizationCodeAuthenticationProvider);
        refreshTokenAuthenticationProvider = new CustomOAuth2RefreshTokenAuthenticationProvider(authorizationService, tokenGenerator, CustomOAuth2ConfigurerUtils.getRegisteredClientRepository(httpSecurity));
        authenticationProviders.add(refreshTokenAuthenticationProvider);
        OAuth2ClientCredentialsAuthenticationProvider clientCredentialsAuthenticationProvider = new OAuth2ClientCredentialsAuthenticationProvider(authorizationService, tokenGenerator);
        authenticationProviders.add(clientCredentialsAuthenticationProvider);
        Consumer<List<AuthenticationProvider>> authenticationProvidersConsumer = authenticationProviders1 -> {};
        authenticationProvidersConsumer.accept(authenticationProviders);
        httpSecurity.authenticationProvider((AuthenticationProvider)refreshTokenAuthenticationProvider);
        return authenticationProvidersConsumer;
    }

    @Bean
    public OAuth2AuthorizationService authorizationService(JdbcTemplate jdbcTemplate, RegisteredClientRepository registeredClientRepository, ObjectMapper objectMapper) {
        JdbcOAuth2AuthorizationService authorizationService = new JdbcOAuth2AuthorizationService((JdbcOperations)jdbcTemplate, registeredClientRepository);
        JdbcOAuth2AuthorizationService.OAuth2AuthorizationRowMapper rowMapper = new JdbcOAuth2AuthorizationService.OAuth2AuthorizationRowMapper(registeredClientRepository);
        ClassLoader classLoader = JdbcOAuth2AuthorizationService.class.getClassLoader();
        objectMapper.registerModules((Iterable)SecurityJackson2Modules.getModules((ClassLoader)classLoader));
        objectMapper.registerModule((Module)new OAuth2AuthorizationServerJackson2Module());
        objectMapper.addMixIn(Long.class, LongMixin.class);
        objectMapper.addMixIn(JSONArray.class, JsonArrayMixin.class);
        rowMapper.setObjectMapper(objectMapper);
        authorizationService.setAuthorizationRowMapper((RowMapper)rowMapper);
        return authorizationService;
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder(BCryptPasswordEncoder.BCryptVersion.$2Y, 10);
    }

    @Bean
    public AuthorizationServerSettings providerSettings() {
        return AuthorizationServerSettings.builder().issuer(this.bennoProviderIssuer).build();
    }

    @Bean
    public OAuth2AuthorizationConsentService authorizationConsentService(JdbcTemplate jdbcTemplate, RegisteredClientRepository registeredClientRepository) {
        return new JdbcOAuth2AuthorizationConsentService((JdbcOperations)jdbcTemplate, registeredClientRepository);
    }

    @Bean
    @Order(value=-2147483648)
    public SecurityFilterChain securityFilterChain(HttpSecurity http, FederatedIdentityConfigurer federatedIdentityConfigurer) throws Exception {
        AuthorizationServerConfig.createDefaultAuthenticationProviders(http);
        OAuth2AuthorizationServerConfigurer authorizationServerConfigurer = new OAuth2AuthorizationServerConfigurer();
        authorizationServerConfigurer.tokenEndpoint(tokenEndpoint -> tokenEndpoint.authenticationProvider((AuthenticationProvider)authorizationCodeAuthenticationProvider)).authorizationEndpoint(authorizationEndpoint -> authorizationEndpoint.consentPage(CUSTOM_CONSENT_PAGE_URI));
        RequestMatcher endpointsMatcher = authorizationServerConfigurer.getEndpointsMatcher();
        Function<OidcUserInfoAuthenticationContext, OidcUserInfo> userInfoMapper = this.createUserInfoMapper();
        ((HttpSecurity)((FederatedIdentityConfigurer)((HttpSecurity)((OAuth2AuthorizationServerConfigurer)((HttpSecurity)http.requestMatcher(endpointsMatcher).authorizeRequests(authorizeRequests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorizeRequests.anyRequest()).authenticated()).formLogin(Customizer.withDefaults()).csrf(csrf -> csrf.ignoringRequestMatchers(new RequestMatcher[]{endpointsMatcher})).cors().configurationSource(this.corsConfigurationSource()).and()).apply((SecurityConfigurerAdapter)authorizationServerConfigurer)).oidc(oidc -> oidc.userInfoEndpoint(userInfo -> userInfo.userInfoMapper(userInfoMapper))).and()).apply((SecurityConfigurerAdapter)federatedIdentityConfigurer)).and()).oauth2ResourceServer().jwt();
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @Order(value=-2147483648)
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration config = new CorsConfiguration();
        if (this.crossOriginUrls != null) {
            ArrayList<String> crossOriginList = new ArrayList<String>(Arrays.asList(this.crossOriginUrls));
            config.setAllowedOrigins(crossOriginList);
        } else {
            config.addAllowedOrigin("*");
        }
        LOGGER.debug("Add following allowed cross origin urls : {}", (Object)config.getAllowedOrigins());
        config.setAllowedMethods(List.of("*"));
        LOGGER.debug("Add following allowed methods : {}", (Object)config.getAllowedMethods());
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return source;
    }

    @Bean
    public JwtDecoder jwtDecoder(JWKSource<SecurityContext> jwkSource) {
        return OAuth2AuthorizationServerConfiguration.jwtDecoder(jwkSource);
    }

    private Function<OidcUserInfoAuthenticationContext, OidcUserInfo> createUserInfoMapper() {
        return context -> this.userinfo.getOidcClaims((OidcUserInfoAuthenticationContext)context);
    }

    @Bean
    public RegisteredClientRepository registeredClientRepository(JdbcTemplate jdbcTemplate, ClientYmlReader clientYmlReader) throws IOException {
        JdbcRegisteredClientRepository registeredClientRepository = new JdbcRegisteredClientRepository((JdbcOperations)jdbcTemplate);
        JdbcRegisteredClientRepository.RegisteredClientParametersMapper registeredClientParametersMapper = new JdbcRegisteredClientRepository.RegisteredClientParametersMapper();
        registeredClientRepository.setRegisteredClientParametersMapper((Function)registeredClientParametersMapper);
        Map<String, Object> clients = clientYmlReader.readYmlFile();
        if (clients.isEmpty()) {
            throw new MissingParameterException("There are no clients available. Add new clients.");
        }
        for (Map.Entry<String, Object> client : clients.entrySet()) {
            this.saveClientToRepository((Client)client.getValue(), (RegisteredClientRepository)registeredClientRepository);
        }
        return registeredClientRepository;
    }

    private void saveClientToRepository(Client bennoClient, RegisteredClientRepository registeredClientRepository) {
        bennoClient.setClientSecret(this.passwordEncoder().encode((CharSequence)bennoClient.getClientSecret()));
        RegisteredClient registeredClient = registeredClientRepository.findByClientId(bennoClient.getClientId());
        if (registeredClient != null) {
            bennoClient.setIdToExistingClient(registeredClient.getId());
        }
        LOGGER.info("Add client {} to client repository", (Object)bennoClient.getClientId());
        registeredClientRepository.save(bennoClient.getRegisteredClient());
    }

    @Bean
    public JWKSource<SecurityContext> jwkSource(KeyGeneratorUtils keyGeneratorUtils) throws JOSEException {
        ArrayList<Object> jwkSets = new ArrayList<Object>();
        jwkSets.add(keyGeneratorUtils.generateRsaKey());
        jwkSets.add(keyGeneratorUtils.generateEcKey());
        JWKSet jwkSet = new JWKSet(jwkSets);
        return (jwkSelector, securityContext) -> jwkSelector.select(jwkSet);
    }
}

