/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.common.config;

import de.lwsystems.mailarchive.bennoauth.authentication.CustomAuthenticationProvider;
import de.lwsystems.mailarchive.bennoauth.fid.FederatedIdentityConfigurer;
import de.lwsystems.mailarchive.bennoauth.user.UserRepositoryOAuth2UserHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.web.cors.CorsConfigurationSource;

@EnableWebSecurity
public class WebSecurityConfig {
    private CustomAuthenticationProvider authProvider;
    private UserRepositoryOAuth2UserHandler userRepositoryOAuth2UserHandler;
    private FederatedIdentityConfigurer federatedIdentityConfigurer;
    private CorsConfigurationSource corsConfigurationSource;

    @Autowired
    public WebSecurityConfig(CustomAuthenticationProvider authProvider, UserRepositoryOAuth2UserHandler userRepositoryOAuth2UserHandler, FederatedIdentityConfigurer federatedIdentityConfigurer, CorsConfigurationSource corsConfigurationSource) {
        this.authProvider = authProvider;
        this.userRepositoryOAuth2UserHandler = userRepositoryOAuth2UserHandler;
        this.federatedIdentityConfigurer = federatedIdentityConfigurer;
        this.corsConfigurationSource = corsConfigurationSource;
    }

    @Autowired
    protected void configure(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider((AuthenticationProvider)this.authProvider);
    }

    @Bean
    SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http) throws Exception {
        ((HttpSecurity)http.cors().configurationSource(this.corsConfigurationSource).and()).authorizeRequests(authorizeRequests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorizeRequests.mvcMatchers(new String[]{"/login"}).permitAll().anyRequest()).authenticated()).formLogin(Customizer.withDefaults()).apply((SecurityConfigurerAdapter)this.federatedIdentityConfigurer.oauth2UserHandler(this.userRepositoryOAuth2UserHandler));
        return (SecurityFilterChain)http.build();
    }
}

