/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.lwsystems.mailarchive.bennoauth.authentication.service.AuthenticationService;
import de.lwsystems.mailarchive.bennoauth.exception.AuthConnectionException;
import de.lwsystems.mailarchive.bennoauth.exception.AuthNotFoundException;
import de.lwsystems.mailarchive.bennoauth.user.User;
import de.lwsystems.mailarchive.bennoauth.user.UserRepository;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClaimUtils {
    private static final Logger LOGGER = LogManager.getLogger(ClaimUtils.class);

    private ClaimUtils() {
    }

    public static Map<String, Object> getClaimsFromAuthService(String username, UserRepository userRepository, AuthenticationService bennoAuthService) throws AuthNotFoundException, AuthConnectionException, IOException {
        if (userRepository.existsByUsername(username)) {
            Optional<User> bennoUser = bennoAuthService.getUserFromAuthenticationService(username);
            ObjectMapper objectMapper = new ObjectMapper();
            if (bennoUser.isPresent()) {
                User user = bennoUser.get();
                try {
                    return (Map)objectMapper.readValue(user.getParameterJsonString(), Map.class);
                }
                catch (JsonProcessingException ex) {
                    LOGGER.error("Can't convert user parameters to json string", (Throwable)ex);
                    return new HashMap<String, Object>();
                }
            }
        }
        LOGGER.debug("Load claims from user {} from the Authentication Service", (Object)username);
        return new HashMap<String, Object>();
    }

    public static Map<String, Object> getClaimsFromDatabase(String username, UserRepository userRepository) {
        if (userRepository.existsByUsername(username)) {
            User user = userRepository.findByUsername(username);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return (Map)objectMapper.readValue(user.getParameterJsonString(), Map.class);
            }
            catch (JsonProcessingException jsonProcessingException) {
                LOGGER.error("Can't convert User parameters to json string", (Throwable)jsonProcessingException);
                return new HashMap<String, Object>();
            }
        }
        LOGGER.debug("Load the User Claims of {} from the Database Service", (Object)username);
        return new HashMap<String, Object>();
    }
}

