/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.common.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class PemUtils {
    private static final Logger LOGGER = LogManager.getLogger(PemUtils.class);

    private PemUtils() {
        throw new IllegalStateException("Utility class");
    }

    private static byte[] parsePEMFile(File pemFile) throws IOException {
        byte[] content;
        if (!pemFile.isFile() || !pemFile.exists()) {
            throw new FileNotFoundException(String.format("The file '%s' doesn't exist.", pemFile.getAbsolutePath()));
        }
        try (PemReader reader = new PemReader((Reader)new FileReader(pemFile));){
            PemObject pemObject = reader.readPemObject();
            content = pemObject.getContent();
            LOGGER.debug("Parse pem file {}", (Object)pemFile.getName());
        }
        return content;
    }

    private static byte[] parseStringFile(String key) throws IOException {
        byte[] content;
        try (PemReader reader = new PemReader((Reader)new StringReader(key));){
            PemObject pemObject = reader.readPemObject();
            content = pemObject.getContent();
            LOGGER.debug("Parse pem string");
        }
        return content;
    }

    private static PublicKey getPublicKey(byte[] keyBytes, String algorithm) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PublicKey publicKey = null;
        try {
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            publicKey = kf.generatePublic(keySpec);
            LOGGER.debug("Create public key with algorithm {}", (Object)algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException("Could not reconstruct the public key, the given algorithm could not be found.");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeySpecException(e.getMessage());
        }
        return publicKey;
    }

    private static PrivateKey getPrivateKey(byte[] keyBytes, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey privateKey = null;
        try {
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            privateKey = kf.generatePrivate(keySpec);
            LOGGER.debug("Create private key with algorithm {}", (Object)algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException("Could not reconstruct the public key, the given algorithm could not be found.");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeySpecException(e.getMessage());
        }
        return privateKey;
    }

    public static PublicKey readPublicKeyFromFile(String filepath, String algorithm) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] bytes = PemUtils.parsePEMFile(new File(filepath));
        return PemUtils.getPublicKey(bytes, algorithm);
    }

    public static PrivateKey readPrivateKeyFromFile(String filepath, String algorithm) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] bytes = PemUtils.parsePEMFile(new File(filepath));
        return PemUtils.getPrivateKey(bytes, algorithm);
    }

    public static PublicKey readPublicKeyFromString(String publicKey, String algorithm) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] bytes = PemUtils.parseStringFile(publicKey);
        return PemUtils.getPublicKey(bytes, algorithm);
    }

    public static PrivateKey readPrivateKeyFromString(String privateKey, String algorithm) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] bytes = PemUtils.parseStringFile(privateKey);
        return PemUtils.getPrivateKey(bytes, algorithm);
    }
}

