/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.fid;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.web.util.UriComponentsBuilder;

public final class FederatedIdentityAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private String authorizationRequestUri = "/oauth2/authorization/{registrationId}";
    private final AuthenticationEntryPoint delegate;
    private final ClientRegistrationRepository clientRegistrationRepository;

    public FederatedIdentityAuthenticationEntryPoint(String loginPageUrl, ClientRegistrationRepository clientRegistrationRepository) {
        this.delegate = new LoginUrlAuthenticationEntryPoint(loginPageUrl);
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authenticationException) throws IOException, ServletException {
        ClientRegistration clientRegistration;
        String idp = request.getParameter("idp");
        if (idp != null && (clientRegistration = this.clientRegistrationRepository.findByRegistrationId(idp)) != null) {
            String redirectUri = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).replaceQuery(null).replacePath(this.authorizationRequestUri).buildAndExpand(new Object[]{clientRegistration.getRegistrationId()}).toUriString();
            this.redirectStrategy.sendRedirect(request, response, redirectUri);
            return;
        }
        this.delegate.commence(request, response, authenticationException);
    }

    public void setAuthorizationRequestUri(String authorizationRequestUri) {
        this.authorizationRequestUri = authorizationRequestUri;
    }
}

