/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.fid;

import de.lwsystems.mailarchive.bennoauth.validator.OIDCTokenValidator;
import java.io.IOException;
import java.util.function.Consumer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;

public final class FederatedIdentityAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private static final Logger LOGGER = LogManager.getLogger(FederatedIdentityAuthenticationSuccessHandler.class);
    private final AuthenticationSuccessHandler delegate = new SavedRequestAwareAuthenticationSuccessHandler();
    ClientRegistrationRepository clientRegistrationRepository;
    OAuth2AuthorizedClientService oAuth2AuthorizedClientService;
    private Consumer<OAuth2User> oauth2UserHandler = user -> {};
    private Consumer<OidcUser> oidcUserHandler = user -> this.oauth2UserHandler.accept((OAuth2User)user);

    public void setClientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    public void setAuth2AuthorizedClientService(OAuth2AuthorizedClientService oAuth2AuthorizedClientService) {
        this.oAuth2AuthorizedClientService = oAuth2AuthorizedClientService;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (authentication instanceof OAuth2AuthenticationToken) {
            if (authentication.getPrincipal() instanceof OidcUser) {
                this.checkOidcToken(authentication);
                this.setOidcUserToOidcUserHandler((OidcUser)authentication.getPrincipal(), ((OAuth2AuthenticationToken)authentication).getAuthorizedClientRegistrationId());
            } else if (authentication.getPrincipal() instanceof OAuth2User) {
                this.setOAuth2UserToOAuth2UserHandler((OAuth2User)authentication.getPrincipal(), ((OAuth2AuthenticationToken)authentication).getAuthorizedClientRegistrationId());
            }
        }
        this.delegate.onAuthenticationSuccess(request, response, authentication);
    }

    private boolean checkOidcToken(Authentication authentication) {
        OIDCTokenValidator oidcTokenValidator = new OIDCTokenValidator(this.clientRegistrationRepository, ((OidcUser)authentication.getPrincipal()).getIdToken().getTokenValue(), ((OAuth2AuthenticationToken)authentication).getAuthorizedClientRegistrationId());
        oidcTokenValidator.checkTokenClaims();
        oidcTokenValidator.checkTokenSignature();
        return true;
    }

    private void setOidcUserToOidcUserHandler(OidcUser oidcUser, String clientId) {
        String username = "";
        String issuer = "";
        if (oidcUser.getPreferredUsername() != null) {
            username = oidcUser.getPreferredUsername();
        }
        if (oidcUser.getIssuer() != null) {
            issuer = oidcUser.getIssuer().toString();
        }
        LOGGER.info("Login for {} at {} with Client {} was successful.", (Object)username, (Object)issuer, (Object)clientId);
        LOGGER.debug(oidcUser.getIdToken().getTokenValue());
        this.oidcUserHandler.accept(oidcUser);
    }

    private void setOAuth2UserToOAuth2UserHandler(OAuth2User oAuth2User, String clientId) {
        String username = "";
        String issuer = "";
        if (oAuth2User.getName() != null) {
            username = oAuth2User.getName();
        }
        issuer = this.getOauth2Issuer(oAuth2User);
        LOGGER.info("Login for {} at {} with client {} was successful.", (Object)username, (Object)issuer, (Object)clientId);
        this.oauth2UserHandler.accept(oAuth2User);
    }

    private String getOauth2Issuer(OAuth2User oAuth2User) {
        try {
            if (Boolean.TRUE.equals(oAuth2User.getAttribute("iss"))) {
                return (String)oAuth2User.getAttribute("iss");
            }
        }
        catch (NullPointerException ex) {
            LOGGER.debug("No issuer found in oAuth2User object");
            return "not_found";
        }
        return "not_found";
    }

    public void setOAuth2UserHandler(Consumer<OAuth2User> oauth2UserHandler) {
        this.oauth2UserHandler = oauth2UserHandler;
    }

    public void setOidcUserHandler(Consumer<OidcUser> oidcUserHandler) {
        this.oidcUserHandler = oidcUserHandler;
    }
}

