/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoauth.fid;

import de.lwsystems.mailarchive.bennoauth.fid.FederatedIdentityAuthenticationEntryPoint;
import de.lwsystems.mailarchive.bennoauth.fid.FederatedIdentityAuthenticationSuccessHandler;
import de.lwsystems.mailarchive.bennoauth.fid.FederatedIdentityOAuth2TokenCustomizer;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public final class FederatedIdentityConfigurer
extends AbstractHttpConfigurer<FederatedIdentityConfigurer, HttpSecurity> {
    private static final Logger LOGGER = LogManager.getLogger(FederatedIdentityConfigurer.class);
    FederatedIdentityOAuth2TokenCustomizer federatedIdentityOAuth2TokenCustomizer;
    OAuth2AuthorizedClientService oAuth2AuthorizedClientService;
    private String loginPageUrl = "/login";
    private String authorizationRequestUri;
    private Consumer<OAuth2User> oauth2UserHandler;
    private Consumer<OidcUser> oidcUserHandler;

    public OAuth2AuthorizedClientService getAuth2AuthorizedClientService() {
        return this.oAuth2AuthorizedClientService;
    }

    @Autowired
    public FederatedIdentityConfigurer(FederatedIdentityOAuth2TokenCustomizer federatedIdentityOAuth2TokenCustomizer) {
        this.federatedIdentityOAuth2TokenCustomizer = federatedIdentityOAuth2TokenCustomizer;
    }

    public FederatedIdentityConfigurer loginPageUrl(String loginPageUrl) {
        this.loginPageUrl = loginPageUrl;
        return this;
    }

    public FederatedIdentityConfigurer authorizationRequestUri(String authorizationRequestUri) {
        this.authorizationRequestUri = authorizationRequestUri;
        return this;
    }

    public FederatedIdentityConfigurer oauth2UserHandler(Consumer<OAuth2User> oauth2UserHandler) {
        this.oauth2UserHandler = oauth2UserHandler;
        return this;
    }

    public FederatedIdentityConfigurer oidcUserHandler(Consumer<OidcUser> oidcUserHandler) {
        this.oidcUserHandler = oidcUserHandler;
        return this;
    }

    @Bean
    public OAuth2AuthorizedClientService oAuth2AuthorizedClientService(Optional<ClientRegistrationRepository> clientRegistrationRepository) {
        if (clientRegistrationRepository.isPresent()) {
            this.oAuth2AuthorizedClientService = new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository.get());
            return this.oAuth2AuthorizedClientService;
        }
        return this.createDummyOAuth2AuthorizedClientService();
    }

    private OAuth2AuthorizedClientService createDummyOAuth2AuthorizedClientService() {
        ClientRegistration clientRegistration = this.createDummyClientRegistration();
        ClientRegistrationRepository clientRegistrationRepository = this.createDummyClientRegistrationRepository(clientRegistration);
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    private ClientRegistration createDummyClientRegistration() {
        return ClientRegistration.withRegistrationId((String)UUID.randomUUID().toString()).clientId("dummy-client-id").authorizationGrantType(new AuthorizationGrantType("none")).build();
    }

    private ClientRegistrationRepository createDummyClientRegistrationRepository(ClientRegistration clientRegistration) {
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{clientRegistration});
    }

    public void init(HttpSecurity http) throws Exception {
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        try {
            ClientRegistrationRepository clientRegistrationRepository = (ClientRegistrationRepository)applicationContext.getBean(ClientRegistrationRepository.class);
            FederatedIdentityAuthenticationEntryPoint authenticationEntryPoint = new FederatedIdentityAuthenticationEntryPoint(this.loginPageUrl, clientRegistrationRepository);
            if (this.authorizationRequestUri != null) {
                authenticationEntryPoint.setAuthorizationRequestUri(this.authorizationRequestUri);
            }
            FederatedIdentityAuthenticationSuccessHandler authenticationSuccessHandler = new FederatedIdentityAuthenticationSuccessHandler();
            if (this.oauth2UserHandler != null) {
                authenticationSuccessHandler.setOAuth2UserHandler(this.oauth2UserHandler);
            }
            if (this.oidcUserHandler != null) {
                authenticationSuccessHandler.setOidcUserHandler(this.oidcUserHandler);
            }
            authenticationSuccessHandler.setClientRegistrationRepository(clientRegistrationRepository);
            authenticationSuccessHandler.setAuth2AuthorizedClientService(this.oAuth2AuthorizedClientService);
            http.exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((AuthenticationEntryPoint)authenticationEntryPoint)).oauth2Login(oauth2Login -> {
                oauth2Login.successHandler((AuthenticationSuccessHandler)authenticationSuccessHandler);
                oauth2Login.authorizedClientService(this.oAuth2AuthorizedClientService);
                if (this.authorizationRequestUri != null) {
                    String baseUri = this.authorizationRequestUri.replace("/{registrationId}", "");
                    oauth2Login.authorizationEndpoint(authorizationEndpoint -> authorizationEndpoint.baseUri(baseUri));
                }
            });
            if (http.getSharedObject(OAuth2TokenCustomizer.class) == null) {
                http.setSharedObject(OAuth2TokenCustomizer.class, (Object)this.federatedIdentityOAuth2TokenCustomizer);
            }
        }
        catch (BeansException ex) {
            LOGGER.warn("No external OAuth2 client was specified. If you want to integrate another OAuth service, register it.");
        }
    }
}

